package ru.yandex.msearch.proxy.api.async.suggest.contact;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

import org.apache.http.HttpException;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.io.StringBuilderWriter;

import ru.yandex.msearch.proxy.MsearchProxyExperiment;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;

import ru.yandex.msearch.proxy.api.async.suggest.highlight
    .HighlightedContactSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.lang.SuggestLanguagePack;
import ru.yandex.msearch.proxy.api.async.suggest.united.AdapterCallback;
import ru.yandex.msearch.proxy.api.async.suggest.united.DefaultSuggestAdapter;
import ru.yandex.msearch.proxy.api.async.suggest.united.SuggestAdapter;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

import ru.yandex.msearch.proxy.api.async.suggest.united.UnitedSuggests;
import ru.yandex.msearch.proxy.config.ImmutableMsearchProxyConfig;
import ru.yandex.msearch.proxy.config.ImmutableSuggestConfig;
import ru.yandex.msearch.proxy.config.SuggestConfig;

import ru.yandex.parser.email.MailAliases;

import ru.yandex.parser.uri.CgiParams;

import ru.yandex.stater.RequestsStater;
import ru.yandex.util.string.StringUtils;

public class ContactSuggestAdaper implements SuggestAdapter {
    private static final String URI =
        DefaultSuggestAdapter.URI_PREFIX
            + Target.CONTACT.name().toLowerCase(Locale.ROOT);

    public static final String LOG_PREFIX = "contact-suggest";
    private final SuggestRule<ContactSuggests> rule;
    private final ImmutableSuggestConfig config;
    private final RequestsStater stater;

    public ContactSuggestAdaper(
        final SuggestRule<ContactSuggests> rule,
        final ImmutableMsearchProxyConfig config)
    {
        this.rule = rule;
        this.config = config.suggestConfig();
        this.stater = null;
    }

    @Override
    public void execute(
        final SuggestRequest<UnitedSuggests> request,
        final CgiParams params,
        final FutureCallback<Suggests<? extends Suggest>> callback)
        throws HttpException
    {
        SuggestRequestParams requestParams =
            new BasicSuggestRequestParams(
                Target.CONTACT,
                params,
                request.requestParams().experiments(),
                config.limit());

        AdapterContactSuggestCallback adapterCallback =
            new AdapterContactSuggestCallback(
                request,
                callback,
                stater);

        SuggestRequest<ContactSuggests> adapted =
            new BasicSuggestRequest<>(
                request.session(),
                new CgiParams(params),
                requestParams,
                adapterCallback,
                LOG_PREFIX);

        adapterCallback.logger(adapted.logger());

        adapted.logger().info("Executing suggest");

        this.rule.execute(adapted);
    }

    @Override
    public void execute(
        final SuggestRequest<UnitedSuggests> request,
        final FutureCallback<Suggests<? extends Suggest>> callback)
        throws HttpException
    {
        this.execute(request, request.cgiParams(), callback);
    }

    private class AdapterContactSuggestCallback
        extends AdapterCallback<ContactSuggests>
    {
        private final SuggestRequestParams requestParams;
        private final boolean pure;
        private final boolean corp;
        private final boolean senderReceiver;

        public AdapterContactSuggestCallback(
            final SuggestRequest<?> request,
            final FutureCallback<Suggests<? extends Suggest>> callback,
            final RequestsStater stater)
            throws HttpException
        {
            super(callback, stater);

            this.requestParams = request.requestParams();

            this.pure = request.cgiParams().getBoolean("pure", false);
            this.corp = request.cgiParams().getBoolean("corp", false);
            this.senderReceiver =
                request.cgiParams().getBoolean("senderReceiver", false);
        }

        @Override
        public void completed(final ContactSuggests suggests) {
            if (pure) {
                super.completed(suggests);
                return;
            }

            ContactSuggests result = suggests;

            if (senderReceiver && !corp && suggests.size() == 1
                && requestParams.length() > 1)
            {
                //PS-3164
                result = new ContactSuggests();
                ContactSuggest suggest = suggests.iterator().next();
                result.add(suggest);
                result.add(
                    createSenderReceiver(
                        suggest,
                        Target.QL,
                        requestParams.language()));
            } else if (config.contactDomainSuggest() && suggests.size() > 1) {
                Set<String> domains = new HashSet<>();
                for (ContactSuggest s: suggests) {
                    domains.add(
                        MailAliases.INSTANCE.extractAndNormalizeDomain(
                            s.email()));
                }

                if (domains.size() == 1) {
                    String domain = domains.iterator().next();
                    if (!MailAliases.INSTANCE.containsDomain(domain)) {
                        suggests.add(
                            new BasicContactSuggest(
                                Target.CONTACT,
                                domain,
                                domain,
                                domain,
                                domain,
                                "",
                                ContactSuggestBuilder.formHash(domain, domain),
                                0,
                                0,
                                10));
                    }
                }
            }

            super.completed(result);
        }
    }

    @Override
    public Target target() {
        return Target.CONTACT;
    }

    private static final ContactSuggest createSenderReceiver(
        final ContactSuggest source,
        final Target target,
        final SuggestLanguagePack language)
    {
        HighlightedContactSuggest hlcs = null;
        ContactSuggest cs;
        if (source instanceof HighlightedContactSuggest) {
            hlcs = (HighlightedContactSuggest) source;
            cs = hlcs.wrapped();
        } else {
            cs = source;
        }

        int boost;
        String prefix = cs.prefix();
        if (target == Target.RECEIVER) {
            prefix += language.ql(SuggestLanguagePack.QL.TO);
            boost = -2;
        } else {
            prefix += language.ql(SuggestLanguagePack.QL.FROM);
            boost = -1;
        }

        String showText =
            StringUtils.concat(prefix, ':', cs.showText());
        String searchText = StringUtils.concat(prefix, ":", cs.email());
        String displayName = StringUtils.concat(prefix, ":", cs.displayName());
        ContactSuggest newCs = new BasicContactSuggest(
            Target.CONTACT,
            displayName,
            cs.email(),
            showText,
            searchText,
            prefix,
            prefix + cs.hash(),
            cs.timestamp(),
            cs.unreadCnt(),
            boost);
        if (hlcs != null) {
            String shinyEmail = hlcs.shinyEmail();
            String shinyName =
                StringUtils.concat(prefix, ":", hlcs.shinyName());

            String shinyShowText =
                StringUtils.concat(prefix, ":", hlcs.shinyShowText());
            newCs =
                new HighlightedContactSuggest(
                    newCs,
                    shinyEmail,
                    shinyName,
                    shinyShowText);
        }

        return newCs;
    }
}
