package ru.yandex.msearch.proxy.api.async.suggest.contact;

import java.io.IOException;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.YandexHeaders;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestSession;

import ru.yandex.msearch.proxy.api.async.suggest.contact.rules
    .AggregateContactSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.contact.rules
    .ContactSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.contact.rules
    .PlainContactSuggestRule;

import ru.yandex.msearch.proxy.api.async.suggest.rules.MultiwordSuggestRule;

import ru.yandex.msearch.proxy.api.async.suggest.united.SuggestAdapter;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

import ru.yandex.msearch.proxy.config.ImmutableContactSuggestConfig;

public class ContactSuggestHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncHttpServer server;
    private final SuggestRule<ContactSuggests> rule;

    public ContactSuggestHandler(final AsyncHttpServer server) {
        this.server = server;

        this.rule = createRule(server);
    }

    private static SuggestRule<ContactSuggests> createRule(
        final AsyncHttpServer server)
    {
        ImmutableContactSuggestConfig contactConfig =
            server.config().suggestConfig().contactConfig();

        SuggestRule<ContactSuggests> rule;
        rule = new PlainContactSuggestRule(server);
        rule = new AggregateContactSuggestRule(server.synonyms(), rule);
        rule = new MultiwordSuggestRule<>(rule);
        rule = new ResolveUserRuleContact<>(rule, server);
        rule = new ContactSuggestRule(contactConfig, rule);

        return rule;
    }

    public static SuggestAdapter createAdapter(final AsyncHttpServer server) {
        return new ContactSuggestAdaper(createRule(server), server.config());
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        SuggestSession session = new SuggestSession(server, exchange, context);

        Header enabledBoxed =
            session.request().getFirstHeader(YandexHeaders.X_ENABLED_BOXES);

        String experimentsString = null;
        if (enabledBoxed != null) {
            experimentsString = enabledBoxed.getValue();
        }
        SuggestRequestParams params =
            new BasicSuggestRequestParams(
                Target.CONTACT,
                session.params(),
                BasicSuggestRequestParams.parseExperiments(experimentsString),
                server.config().suggestConfig().limit());

        ContactSuggestPrinter printer =
            new ContactSuggestPrinter(session, params);

        SuggestRequest<ContactSuggests> suggestRequest =
            new BasicSuggestRequest<>(
                session,
                params,
                printer,
                ContactSuggestAdaper.LOG_PREFIX);

        rule.execute(suggestRequest);
    }
}
