package ru.yandex.msearch.proxy.api.async.suggest.contact;

import java.io.IOException;
import java.io.OutputStreamWriter;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

import java.util.Collections;
import java.util.logging.Level;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.protocol.HttpCoreContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;

import ru.yandex.http.util.server.LoggingServerConnection;

import ru.yandex.io.DecodableByteArrayOutputStream;

import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestParams;

public class ContactSuggestPrinter
    extends AbstractProxySessionCallback<ContactSuggests>
{
    private final JsonType jsonType;
    private final SuggestRequestParams params;

    public ContactSuggestPrinter(
        final ProxySession session,
        final SuggestRequestParams params)
        throws BadRequestException
    {
        super(session);

        jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        this.params = params;
    }

    @Override
    public void completed(final ContactSuggests suggests) {
        session.connection().setHitsCount(Long.toString(suggests.size()));
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        CharsetEncoder encoder = session.acceptedCharset().newEncoder()
            .onMalformedInput(CodingErrorAction.REPLACE)
            .onUnmappableCharacter(CodingErrorAction.REPLACE);

        try (OutputStreamWriter outWriter = new OutputStreamWriter(out, encoder);
             JsonWriter writer = jsonType.create(outWriter))
        {
            writer.startObject();
            writer.key("contacts");
            writer.startArray();
            for (ContactSuggest cs: suggests) {
                writer.startObject();
                writer.key("id");
                writer.value(-2);
                writer.key("email");
                writer.value(cs.email());
                writer.key("name");
                writer.value(cs.displayName());
                writer.key("phones");
                writer.value(Collections.<String>emptyList());
                writer.key("t");
                writer.value(String.valueOf(cs.timestamp()));
                writer.key("u");
                writer.value(-1);
                writer.key("target");
                writer.value(cs.target().toString());
                writer.key("show_text");
                writer.value(cs.showText());
                writer.key("search_text");
                writer.value(cs.searchText());
                writer.endObject();
            }

            writer.endArray();
            writer.endObject();
        } catch (IOException ioe) {
            failed(ioe);
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                session.acceptedCharset())
                .toString());
        session.response(HttpStatus.SC_OK, entity);
    }

    @Override
    public void failed(final Exception e) {
        session.logger().log(
            Level.WARNING,
            "Request failed: \n" + session.listener().details(),
            e);

        session.handleException(HttpExceptionConverter.toHttpException(e));
    }

    @Override
    public void cancelled() {
        session.logger().warning("Request cancelled");
    }
}
