package ru.yandex.msearch.proxy.api.async.suggest.contact;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import ru.yandex.msearch.proxy.api.async.suggest.Suggests;

public class ContactSuggests implements Suggests<ContactSuggest> {
    private static final Comparator<ContactSuggest> ORDER_COMPARATOR =
        (o1, o2) -> {
            if (o1.boost() == o2.boost()) {
                if (o1.timestamp() == o2.timestamp()) {
                    return o1.hash().compareTo(o2.hash());
                } else {
                    return -Long.compare(o1.timestamp(), o2.timestamp());
                }
            } else {
                return -Integer.compare(o1.boost(), o2.boost());
            }
        };

    private final Map<String, ContactSuggest> suggests;

    public ContactSuggests() {
        this.suggests = new HashMap<>();
    }

    private List<ContactSuggest> sort() {
        List<ContactSuggest> result = new ArrayList<>(suggests.values());
        result.sort(ORDER_COMPARATOR);
        return result;
    }

    public synchronized void add(final ContactSuggest suggest) {
        String hash = suggest.hash();
        ContactSuggest current = this.suggests.putIfAbsent(hash, suggest);
        if (current != null) {
            if (ORDER_COMPARATOR.compare(current, suggest) > 0) {
                suggests.put(hash, suggest);
            }
        }
    }

    @Override
    public Iterator<ContactSuggest> iterator() {
        return sort().iterator();
    }

    public ContactSuggests head(final int limit) {
        if (size() <= limit) {
            return this;
        }
        ContactSuggests result = new ContactSuggests();
        List<ContactSuggest> suggests = sort();
        for (ContactSuggest suggest: suggests.subList(0, limit)) {
            result.add(suggest);
        }
        return result;
    }

    public int size() {
        return suggests.size();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        suggests.values().forEach(v -> sb.append(v.toString() + "\n"));
        return sb.toString();
    }
}
