package ru.yandex.msearch.proxy.api.async.suggest.contact;

import java.io.IOException;

import ru.yandex.msearch.proxy.api.async.suggest.lang.SuggestLanguagePack;
import ru.yandex.msearch.proxy.api.async.suggest.lang.SuggestLanguagePack.QL;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;
import ru.yandex.util.string.StringUtils;

public class QLContactSuggest extends ContactSuggest {
    private final Target target;
    private final ContactSuggest wrapped;
    private final String searchText;
    private final String hash;
    private final String prefix;
    private final String showText;
    private final int boost;

    public QLContactSuggest(
        final Target target,
        final ContactSuggest cs,
        final SuggestLanguagePack language)
    {
        String prefix = cs.prefix();
        if (target == Target.RECEIVER) {
            this.target = target;
            prefix += language.ql(QL.TO);
            boost = -2;
        } else {
            this.target = target;
            prefix += language.ql(QL.FROM);
            boost = -1;
        }

        this.wrapped = cs;

        this.showText = StringUtils.concat(prefix, ':', cs.showText());
        this.prefix = prefix;
        this.hash =
            prefix + "\"" + cs.displayName() + "\" " + cs.email();

        this.searchText = StringUtils.concat(prefix, ":",  cs.email());
    }

    @Override
    public ContactSuggest withPrefix(final String prefix) {
        return this;
    }

    @Override
    public String hash() {
        return hash;
    }

    @Override
    public String email() {
        return wrapped.email();
    }

    @Override
    public String displayName() {
        return wrapped.displayName();
    }

    @Override
    public long timestamp() {
        return wrapped.timestamp();
    }

    @Override
    public int boost() {
        return boost;
    }

    @Override
    public String emailLow() {
        return wrapped.emailLow();
    }

    @Override
    public int unreadCnt() {
        return wrapped.unreadCnt();
    }

    @Override
    public Target target() {
        return target;
    }

    @Override
    public String showText() {
        return showText;
    }

    @Override
    public String searchText() {
        return searchText;
    }

    @Override
    public String prefix() {
        return prefix;
    }

    @Override
    public String toString() {
        return "ContactSuggest{" +
            "displayName='" + displayName() + '\'' +
            ", email='" + email() + '\'' +
            ", emailLow='" + emailLow() + '\'' +
            ", unreadCnt=" + unreadCnt() +
            ", searchTxt='" + searchText() + '\'' +
            ", showText='" + showText() + '\'' +
            ", hash='" + hash().hashCode() + '\'' +
            ", timestamp=" + timestamp() +
            '}';
    }

    @Override
    public boolean filterable() {
        return wrapped.filterable();
    }
}
