package ru.yandex.msearch.proxy.api.async.suggest.contact;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.blackbox.BlackboxAddress;
import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.blackbox.BlackboxDbfield;
import ru.yandex.blackbox.BlackboxEmailsType;
import ru.yandex.blackbox.BlackboxUserIdType;
import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.blackbox.BlackboxUserinfoRequest;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;

import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;

import ru.yandex.parser.uri.CgiParams;

public class ResolveUserRuleContact<T extends Suggests<? extends Suggest>>
    implements SuggestRule<T>
{
    private static final String SUID = "suid";
    private static final String UID = "uid";
    private static final String MDB = "mdb";

    private final SuggestRule<T> next;
    private final AsyncHttpServer server;

    public ResolveUserRuleContact(
        final SuggestRule<T> next,
        final AsyncHttpServer server)
    {
        this.next = next;
        this.server = server;
    }

    @Override
    public void execute(final SuggestRequest<T> request) throws HttpException {
        CgiParams params = request.cgiParams();
        Long suid = params.getLong(SUID, null);
        Long uid = params.getLong(UID, null);

        if (suid == null && uid == null) {
            request.callback().failed(
                new BadRequestException("No user id supplied"));
            return;
        }

        if ((uid != null && BlackboxUserinfo.corp(uid))
            || (suid != null && BlackboxUserinfo.corp(suid)))
        {
            params.add("corp", "1");
        }

        BlackboxClient client;

        if (suid == null) {
            client = server.blackboxClient(uid, request.session().context());
            client.userinfo(
                new BlackboxUserinfoRequest(uid)
                    .requiredDbfields(
                        BlackboxDbfield.MDB,
                        BlackboxDbfield.SUID)
                    .emailsType(BlackboxEmailsType.GETALL)
                    .addHeader(
                        YandexHeaders.X_YA_SERVICE_TICKET,
                        server.blackboxTvm2Ticket(uid)),
                request.session().requestsListener()
                    .createContextGeneratorFor(client),
                new BlackboxCallback(request, BlackboxUserIdType.SUID));
        } else {
            client = server.blackboxClient(suid, request.session().context());
            client.userinfo(
                new BlackboxUserinfoRequest(BlackboxUserIdType.SUID, suid)
                    .requiredDbfields(BlackboxDbfield.MDB)
                    .emailsType(BlackboxEmailsType.GETALL)
                    .addHeader(
                        YandexHeaders.X_YA_SERVICE_TICKET,
                        server.blackboxTvm2Ticket(suid)),
                request.session().requestsListener()
                    .createContextGeneratorFor(client),
                new BlackboxCallback(request, BlackboxUserIdType.UID));
        }
    }

    private class BlackboxCallback
        extends AbstractFilterFutureCallback<List<BlackboxUserinfo>, T>
    {
        private final BlackboxUserIdType type;
        private final SuggestRequest<T> request;

        public BlackboxCallback(
            final SuggestRequest<T> request,
            final BlackboxUserIdType type)
        {
            super(request.callback());
            this.request = request;
            this.type = type;
        }

        @Override
        public void completed(final List<BlackboxUserinfo> userInfos) {
            CgiParams params = new CgiParams(request.cgiParams());
            BlackboxUserinfo userinfo = userInfos.get(0);
            params.replace(
                MDB,
                userinfo.dbfields().get(BlackboxDbfield.MDB));

            if (type == BlackboxUserIdType.SUID) {
                params.replace(
                    SUID,
                    userinfo.dbfields().get(BlackboxDbfield.SUID));
            } else {
                params.replace(UID, String.valueOf(userinfo.uid()));
            }

            Set<String> selfEmails = new HashSet<>();
            for (BlackboxUserinfo info: userInfos) {
                for (BlackboxAddress address: info.addressList()) {
                    if (address != null && !address.email().isEmpty()) {
                        selfEmails.add(address.email());
                    }
                }
            }
            params.replace("selfEmails", selfEmails);
            request.logger().info("Self emails: " + selfEmails);

            try {
                next.execute(request.withCgiParams(params));
            } catch (HttpException e) {
                failed(e);
            }
        }
    }
}
