package ru.yandex.msearch.proxy.api.async.suggest.contact;

import java.util.HashSet;
import java.util.Set;

public class TokenizeRule {
    private final Set<Token> tokens;
    private final boolean searchable;

    public TokenizeRule(
        final Set<Token> tokens,
        final boolean searchable)
    {
        if (tokens != null) {
            this.tokens = tokens;
        } else {
            this.tokens = new HashSet<>();
        }
        this.searchable = searchable;
    }

    public Set<Token> tokens() {
        return tokens;
    }

    public boolean searchable() {
        return searchable;
    }

    public static class RuleComparator {
        private final HashSet<Token> tokens;
        private final int hashCode;

        public RuleComparator(final Set<Token> tokens) {
            this.tokens = new HashSet<>(tokens);
            int hashCode = 0;
            for (Token token: tokens) {
                hashCode += token.hashCode();
            }
            this.hashCode = hashCode;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object o) {
            RuleComparator other = (RuleComparator) o;
            return tokens.equals(other.tokens);
        }

    }
}
