package ru.yandex.msearch.proxy.api.async.suggest.contact;

import ru.yandex.msearch.proxy.api.async.suggest.highlight
    .HighlightedContactSuggest;

import ru.yandex.msearch.proxy.highlight.HtmlHighlighter;

public class WordsStartContactSuggestBuilder extends ContactSuggestBuilder {
    public WordsStartContactSuggestBuilder() {
    }

    protected ContactSuggest doHighlight(
        final String displayName,
        final String email,
        final ContactSuggest suggest)
    {
        String shinyName =
            HtmlHighlighter.INSTANCE.highlight(requests, displayName, false);
        String shinyEmail =
            HtmlHighlighter.INSTANCE.highlight(requests, email, false);

        return new HighlightedContactSuggest(suggest, shinyEmail, shinyName);
    }

    public static ContactSuggestBuilder create(
        final ContactParser.Email email)
    {
        WordsStartContactSuggestBuilder builder =
            new WordsStartContactSuggestBuilder();
        return builder.email(email);
    }
}
