package ru.yandex.msearch.proxy.api.async.suggest.contact.corp;

import java.util.Collections;
import java.util.Set;

import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser.Email;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactSuggestBuilder;
import ru.yandex.search.result.SearchDocument;

public class AtushkaContactProcessor implements CorpContactProcessor {
    public static final AtushkaContactProcessor INSTANCE =
        new AtushkaContactProcessor();

    private static final Set<String> ATUSHKA_EXTRACT_HEADERS =
        Collections.singleton("hdr_from");

    private static final String ROBOT_ATUSHKA = "robot-atushka";
    private static final String ATUSHKA_EMAIL_PREFIX = ROBOT_ATUSHKA + '@';

    @Override
    public Set<String> headers() {
        return ATUSHKA_EXTRACT_HEADERS;
    }

    @Override
    public CorpContactSuggestBuilder process(
        final Email email,
        final SearchDocument document,
        final String prefix,
        final long ts)
    {
        if (email.name().isEmpty()
            || !email.address().startsWith(ATUSHKA_EMAIL_PREFIX))
        {
            return null;
        }

        int lastOpenBracket = email.name().lastIndexOf('(');
        int lastCloseBracket = email.name().lastIndexOf(')');
        String login = null;

        if (lastCloseBracket > lastOpenBracket) {
            login =
                email.name().substring(lastOpenBracket + 1, lastCloseBracket);
        }

        if (login == null || login.isEmpty()) {
            return null;
        }

        String fullName = email.name().substring(0, lastOpenBracket).trim();
        if (fullName.isEmpty()) {
            return null;
        }

        CorpContactSuggestBuilder builder = CorpContactSuggestBuilder
            .create(new Email(fullName, email.address()));
        builder
            .login(login)
            .prefix(prefix)
            .ts(ts - 2);
        return builder;
    }
}
