package ru.yandex.msearch.proxy.api.async.suggest.contact.corp;

import java.util.Collections;
import java.util.Set;

import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser.Email;

import ru.yandex.search.document.mail.MailMetaInfo;

import ru.yandex.search.result.SearchDocument;

public class CalendarContactProcessor implements CorpContactProcessor {
    public static final CalendarContactProcessor INSTANCE =
        new CalendarContactProcessor();

    private static final String CALENDAR_ADDRESS
        = "info@calendar.yandex-team.ru";

    private static final Set<String> HEADERS =
        Collections.singleton(MailMetaInfo.HDR + MailMetaInfo.FROM);

    @Override
    public Set<String> headers() {
        return HEADERS;
    }

    @Override
    public CorpContactSuggestBuilder process(
        final Email email,
        final SearchDocument document,
        final String prefix,
        final long ts)
    {
        if (!CALENDAR_ADDRESS.equalsIgnoreCase(email.address())) {
            return null;
        }

        String replyTo = document.attrs().get("reply_to_normalized");
        if (replyTo == null) {
            return null;
        }

        String login = null;
        int atIndex = replyTo.indexOf('@');
        if (atIndex > 0) {
            login = replyTo.substring(0, atIndex).trim();
        }

        if (login == null) {
            return null;
        }

        CorpContactSuggestBuilder builder = CorpContactSuggestBuilder
            .create(new Email(email.name(), email.address()));
        builder
            .login(login)
            .prefix(prefix)
            .ts(ts);
        return builder;
    }
}
