package ru.yandex.msearch.proxy.api.async.suggest.contact.corp;

import java.util.Collection;

import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser;
import ru.yandex.search.result.SearchDocument;

public class CorpContactParser extends ContactParser {
    public static Email parseEmail(final String str) {
        if (str.startsWith("=?") && str.endsWith("?=")
            || str.startsWith("<=?") && str.endsWith("?=>"))
        {
            String decoded =
                DecoderUtil.decodeEncodedWords(str, DecodeMonitor.SILENT);
            if (!decoded.equals(str)) {
                return parseEmail(decoded);
            }
        }

        boolean escaped = false;
        int commaIndex = -1;
        for (int i = 0; i < str.length(); i++) {
            int ch = str.charAt(i);
            if (ch == '\\' && !escaped) {
                escaped = true;
            } else {
                if (ch == ',' && !escaped) {
                    commaIndex = i;
                    break;
                }

                escaped = false;
            }
        }

        String emailStr = str;
        if (commaIndex > 0) {
            emailStr = str.substring(0, commaIndex);
        }

        return ContactParser.parseEmail(emailStr);
    }

    public static Email parse(
        final SearchDocument doc,
        final String header,
        final Collection<String> excludeSet)
    {
        String headerStr = doc.attrs().get(header);
        if (headerStr == null) {
            return null;
        }

        headerStr = headerStr.trim();
        if (headerStr.length() == 0 || excludeSet.contains(headerStr)) {
            return null;
        }

        Email email = CorpContactParser.parseEmail(headerStr);

        if (email == null || excludeSet.contains(email.address())) {
            return null;
        }

        if (email.name() == null || email.name().isEmpty()) {
            int atIndex = email.address().indexOf('@');
            if (atIndex > 0) {
                String name =
                    removeQuotes(email.address().substring(0, atIndex))
                    .replace(',', ' ')
                    .replace('\"', ' ')
                    .replace('\'', ' ')
                    .replace('\\', ' ')
                    .replace('<', ' ')
                    .replace('>', ' ')
                    .trim();
                email = new Email(name, email.address());
            }
        }

        return email;
    }
}
