package ru.yandex.msearch.proxy.api.async.suggest.contact.corp;

import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser.Email;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactSuggestBuilder;

public class CorpContactSuggestBuilder extends ContactSuggestBuilder {
    protected String login;

    public String login() {
        return login;
    }

    public CorpContactSuggestBuilder login(final String login) {
        this.login = login;
        return this;
    }

    public ContactSuggest build() {
        String displayName = formName(rawDisplayName, rawEmail);
        StringBuilder prefixSb =
            new StringBuilder(
                prefix.length() + login.length() + 7);
        prefixSb.append(prefix);
        if (prefixSb.length() > 0) {
            prefixSb.append(' ');
        }

        prefixSb.append("from:(");
        prefixSb.append(login);
        prefixSb.append(' ');

        String searchTxt = prefixSb.toString() + rawEmail + ')';
        String email = rawEmail;

        String showText = buildShowText(displayName, email);
        ContactSuggest suggest = new YtContactSuggest(
            target,
            login,
            displayName,
            email,
            showText,
            searchTxt,
            prefix,
            formHash(rawDisplayName, rawEmail),
            timestamp,
            unreadCnt,
            boost);

        if (highlight) {
            suggest = doHighlight(displayName, email, suggest);
        }

        return suggest;
    }

    public static CorpContactSuggestBuilder create(final Email email) {
        CorpContactSuggestBuilder builder = new CorpContactSuggestBuilder();
        builder.email(email);
        return builder;
    }
}
