package ru.yandex.msearch.proxy.api.async.suggest.contact.corp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.suggest.SuggestLuceneRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;

import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser.Email;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactSuggestBuilder;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactSuggests;

import ru.yandex.msearch.proxy.api.async.suggest.contact.rules
    .PlainContactSuggestCallback;

import ru.yandex.search.result.SearchDocument;

public class CorpPlainContactSuggestCallback
    extends PlainContactSuggestCallback
{
    private static final List<CorpContactProcessor> PROCESSORS
        = Collections.unmodifiableList(Arrays.asList(
            StartrekContactProcessor.INSTANCE,
            AtushkaContactProcessor.INSTANCE,
            CalendarContactProcessor.INSTANCE,
            WikiContactProcessor.INSTANCE));

    public CorpPlainContactSuggestCallback(
        final AsyncHttpServer server,
        final SuggestLuceneRequest searchRequest,
        final SuggestRequest<ContactSuggests> suggestRequest)
        throws BadRequestException
    {
        super(server, searchRequest, suggestRequest);
    }

    @Override
    protected ContactSuggestBuilder getBuilder(
        final Email email,
        final SearchDocument doc,
        final String header,
        final long ts)
    {
        ContactSuggestBuilder builder;
        for (CorpContactProcessor processor: PROCESSORS) {
            if (processor.headers().contains(header)) {
                builder = processor.process(email, doc, prefix, ts);
                if (builder != null) {
                    return builder;
                }
            }
        }
        return ContactSuggestBuilder.create(email).prefix(prefix).ts(ts);
    }
}
