package ru.yandex.msearch.proxy.api.async.suggest.contact.corp;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser.Email;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactSuggestBuilder;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.result.SearchDocument;

public class StartrekContactProcessor implements CorpContactProcessor {
    public static final StartrekContactProcessor INSTANCE =
        new StartrekContactProcessor();

    private static final String STARTEK_DISPLAY_NAME_PREF = "(st)";
    private static final String STARTEK_DISPLAY_NAME = "Startrek";

    private static final char STARTEK_LOGIN_NAME_SEP = '–';
    private static final String[] STARTREK_PREFIXES = {
        "startrek@", "st@"
    };

    private static final String DEFAULT_STARTREK_EMAIL
        = "startrek@yandex-team.ru";

    private static final Set<String> STARTREK_EXTRACT_HEADERS =
        new HashSet<>(
            Arrays.asList(
                MailMetaInfo.HDR + MailMetaInfo.FROM,
                MailMetaInfo.HDR + MailMetaInfo.TO));

    private boolean isSpace(final int c) {
        return Character.isWhitespace(c)
            || Character.isISOControl(c)
            || Character.isSpaceChar(c);
    }

    @Override
    public Set<String> headers() {
        return STARTREK_EXTRACT_HEADERS;
    }

    @Override
    public CorpContactSuggestBuilder process(
        final Email email,
        final SearchDocument document,
        final String prefix,
        final long ts)
    {
        boolean startrek = false;

        for (String stPrefix: STARTREK_PREFIXES) {
            if (email.address().startsWith(stPrefix)) {
                startrek = true;
                break;
            }
        }

        if (!startrek) {
            return null;
        }

        int stIndex = email.name().indexOf(STARTEK_DISPLAY_NAME_PREF) + 5;
        boolean started = false;
        int endIndex = -1;
        for (int i = stIndex; i < email.name().length(); i++) {
            int c = email.name().charAt(i);
            if (!started) {
                if (isSpace(c)) {
                    continue;
                } else {
                    started = true;
                }
            }

            if (isSpace(c)) {
                endIndex = i;
                break;
            }
        }

        String login = null;
        String fullName = null;
        if (endIndex > 0) {
            login = email.name().substring(stIndex, endIndex);

            stIndex =
                email.name()
                    .indexOf(STARTEK_LOGIN_NAME_SEP, endIndex) + 1;

            if (stIndex > 0) {
                fullName = email.name().substring(stIndex).trim();
                if (login.startsWith("robot-")) {
                    String[] split = fullName.split("\\s+");
                    if (split.length == 2
                        && login.equals(split[0])
                        && split[0].equals(split[1]))
                    {
                        fullName = login;
                    }
                }
            }
        }

        if (login != null && fullName != null) {
            CorpContactSuggestBuilder builder =
                CorpContactSuggestBuilder.create(
                    new Email(fullName, DEFAULT_STARTREK_EMAIL));

            builder
                .login(login)
                .prefix(prefix)
                .postfix(")")
                .ts(ts - 1);
            return builder;
        }

        return null;
    }
}
