package ru.yandex.msearch.proxy.api.async.suggest.contact.corp;

import java.util.Collections;
import java.util.Set;

import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser.Email;

import ru.yandex.search.document.mail.MailMetaInfo;

import ru.yandex.search.result.SearchDocument;

public class WikiContactProcessor implements CorpContactProcessor {
    public static final WikiContactProcessor INSTANCE =
        new WikiContactProcessor();

    private static final String WIKI_PREFIX = "(Wiki)";

    private static final String WIKI_ADDRESS
        = "wiki@yandex-team.ru";

    private static final Set<String> HEADERS =
        Collections.singleton(MailMetaInfo.HDR + MailMetaInfo.FROM);

    @Override
    public Set<String> headers() {
        return HEADERS;
    }

    @Override
    public CorpContactSuggestBuilder process(
        final Email email,
        final SearchDocument document,
        final String prefix,
        final long ts)
    {
        if (!WIKI_ADDRESS.equalsIgnoreCase(email.address())) {
            return null;
        }

        String name = email.name().trim();
        if (!name.startsWith(WIKI_PREFIX)) {
            return null;
        }

        String replyTo = document.attrs().get("reply_to_normalized");
        if (replyTo == null) {
            return null;
        }

        String login = null;
        int atIndex = replyTo.indexOf('@');
        if (atIndex > 0) {
            login = replyTo.substring(0, atIndex).trim();
        }

        if (login == null) {
            return null;
        }

        String fullName = name.substring(WIKI_PREFIX.length()).trim();

        CorpContactSuggestBuilder builder = CorpContactSuggestBuilder
            .create(new Email(fullName, email.address()));
        builder
            .login(login)
            .prefix(prefix)
            .ts(ts - 3);

        return builder;
    }
}
