package ru.yandex.msearch.proxy.api.async.suggest.contact.corp;

import ru.yandex.msearch.proxy.api.async.suggest.contact.BasicContactSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;
import ru.yandex.util.string.StringUtils;

public class YtContactSuggest extends BasicContactSuggest {
    private final String login;
    private final String groupHash;

    public YtContactSuggest(
        final Target target,
        final String login,
        final String displayName,
        final String email,
        final String showText,
        final String searchTxt,
        final String prefix,
        final String hash,
        final long timestamp,
        final int unreadCnt,
        final int boost)
    {
        super(
            target,
            displayName,
            email,
            showText,
            searchTxt,
            prefix,
            hash,
            timestamp,
            unreadCnt,
            boost);

        this.login = login;

        this.groupHash
            = StringUtils.concat(login, " ", emailLow);
    }

    public String login() {
        return login;
    }

    @Override
    public boolean filterable() {
        return false;
    }
}
