package ru.yandex.msearch.proxy.api.async.suggest.contact.rules;

import org.apache.http.HttpException;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.Session;

import ru.yandex.msearch.proxy.api.async.suggest.SuggestLuceneRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;

import ru.yandex.msearch.proxy.api.async.suggest.contact
    .ContactSuggestLuceneRequest;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactSuggests;

import ru.yandex.msearch.proxy.api.async.suggest.contact.corp
    .CorpPlainContactSuggestCallback;
import ru.yandex.msearch.proxy.api.async.suggest.rules
    .AbstractPlainSuggestCallback;
import ru.yandex.msearch.proxy.api.async.suggest.rules.PlainSuggestRule;

public class PlainContactSuggestRule
    extends PlainSuggestRule<ContactSuggests>
{
    public PlainContactSuggestRule(
        final AsyncHttpServer server)
    {
        super(server);
    }

    @Override
    protected SuggestLuceneRequest buildRequest(
        final SuggestRequest<ContactSuggests> request,
        final PrefixedLogger logger)
        throws HttpException
    {
        return new ContactSuggestLuceneRequest(
            server,
            request,
            logger);
    }

    @Override
    public AbstractPlainSuggestCallback<ContactSuggests> createCallback(
        final AsyncHttpServer server,
        final SuggestLuceneRequest searchRequest,
        final SuggestRequest<ContactSuggests> suggestRequest)
        throws HttpException
    {
        if (suggestRequest.cgiParams().getBoolean("corp", false)) {
            return new CorpPlainContactSuggestCallback(
                server,
                searchRequest,
                suggestRequest);
        }

        return new PlainContactSuggestCallback(
            server,
            searchRequest,
            suggestRequest);
    }

    @Override
    public PrefixedLogger logger(final Session session) {
        return session.logger().addPrefix("contact-suggest");
    }
}
