package ru.yandex.msearch.proxy.api.async.suggest.folder;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

public class FolderSuggest extends BasicSuggest {
    private static final String FID = "fid";

    private final String fids;

    public FolderSuggest(
        final String showText,
        final String searchText,
        final String fids)
    {
        this(Target.FOLDER, showText, searchText, fids);
    }

    public FolderSuggest(
        final Target target,
        final String showText,
        final String searchText,
        final String fids)
    {
        this(target, showText, searchText, Collections.emptyMap(), fids);
    }

    public FolderSuggest(
        final Target target,
        final String showText,
        final String searchText,
        final Map<String, String> searchParams,
        final String fids)
    {
        super(target, showText, searchText, searchParams);

        this.fids = fids;
    }

    public String fids() {
        return fids;
    }

    @Override
    public Suggest withPrefix(
        final String prefix)
    {
        return new FolderSuggest(
            target(),
            showText(),
            prefix + searchText(),
            fids());
    }

    @Override
    public void appendToWriter(final JsonWriterBase writer)
        throws IOException
    {
        super.appendToWriter(writer);
        writer.key(FID);
        writer.value(fids);
    }
}
