package ru.yandex.msearch.proxy.api.async.suggest.folder;

import java.util.HashMap;
import java.util.Map;

public class Folders {
    private final Map<String, Folder> userFolders;
    private final Map<String, String> systemFolders;

    public Folders(final int size) {
        userFolders = new HashMap<>(size);
        // systemFolders size is less 10 default value is ok
        systemFolders = new HashMap<>();
    }

    public void addUser(final String fid, final Folder folder) {
        userFolders.put(fid, folder);
    }

    public void addSystem(final String fid, final String folder) {
        systemFolders.put(fid, folder);
    }

    public Map<String, Folder> user() {
        return userFolders;
    }

    public Map<String, String> system() {
        return systemFolders;
    }
}
