package ru.yandex.msearch.proxy.api.async.suggest.folder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;

import ru.yandex.json.dom.BasicContainerFactory;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonObject.Type;

import ru.yandex.json.parser.StringCollectorsFactory;

public class SuggestFolderConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<Folders>
{
    public SuggestFolderConsumer(
        final HttpEntity entity)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    @Override
    protected Folders buildResult(
        final HttpContext context,
        final JsonObject root)
        throws Exception
    {

        JsonMap foldersMap = root.get("folders").asMap();
        Folders folders = new Folders(foldersMap.size());
        List<PathHolder> delayed = new ArrayList<>(foldersMap.size());

        for (Map.Entry<String, JsonObject> folder : foldersMap.entrySet()) {
            JsonMap map = folder.getValue().asMap();
            String parentId = map.get("parentId").asStringOrNull();
            JsonObject fType = map.get("type");
            if (fType.type() != Type.MAP) {
                continue;
            }

            String typeTitle = fType.get("title").asStringOrNull();

            String fid = folder.getKey();
            String path = map.get("name").asStringOrNull();
            if (path != null) {
                if ("user".equalsIgnoreCase(typeTitle)) {
                    if (parentId == null || "0".equals(parentId)) {
                        folders.addUser(fid, new Folder(path));
                    } else {
                        Folder parent = folders.user().get(parentId);
                        if (parent != null) {
                            folders.addUser(fid, new Folder(path, parent));
                        }

                        delayed.add(new PathHolder(path, parentId, fid));
                    }
                } else {
                    folders.addSystem(fid, path);
                }
            }
        }

        if (!delayed.isEmpty()) {
            Collections.sort(delayed);
            for (PathHolder holder: delayed) {
                Folder parent = folders.user().get(holder.pid);
                if (parent != null) {
                    folders.addUser(
                        holder.fid(),
                        new Folder(holder.path(), parent));
                }
            }
        }

        return folders;
    }

    private static final class PathHolder implements Comparable<PathHolder> {
        private final String path;
        private final String pid;
        private final String fid;
        private final int separators;

        public PathHolder(
            final String path,
            final String pid,
            final String fid)
        {
            this.path = path;
            this.pid = pid;
            this.fid = fid;

            int count = 0;
            for (int i = 0; i < path.length(); i++) {
                if (path.charAt(i) == '|') {
                    count += 1;
                }
            }

            this.separators = count;
        }

        public String path() {
            return path;
        }

        public int separators() {
            return separators;
        }

        public String pid() {
            return pid;
        }

        public String fid() {
            return fid;
        }

        @Override
        public int compareTo(final PathHolder o) {
            return Integer.compare(separators, o.separators);
        }
    }
}
