package ru.yandex.msearch.proxy.api.async.suggest.highlight;

import java.io.IOException;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.msearch.proxy.api.async.suggest.contact.BasicContactSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

public class HighlightedContactSuggest extends ContactSuggest {
    private static final String EMAIL_HIGHLIGHTED = "email_highlighted";
    private static final String NAME_HIGHLIGHTED = "display_name_highlighted";

    private final ContactSuggest suggest;

    protected final String shinyEmail;
    protected final String shinyName;
    protected final String shinyShowText;

    public HighlightedContactSuggest(
        final ContactSuggest suggest,
        final String shinyEmail,
        final String shinyName)
    {
        this.suggest = suggest;
        this.shinyEmail = shinyEmail;
        this.shinyName = shinyName;
        this.shinyShowText =
            BasicContactSuggest.showText(shinyName, shinyEmail);
    }

    public HighlightedContactSuggest(
        final ContactSuggest suggest,
        final String shinyEmail,
        final String shinyName,
        final String shinyShowText)
    {
        this.suggest = suggest;
        this.shinyEmail = shinyEmail;
        this.shinyName = shinyName;
        this.shinyShowText = shinyShowText;
    }

    public ContactSuggest wrapped() {
        return suggest;
    }

    public String shinyEmail() {
        return shinyEmail;
    }

    public String shinyName() {
        return shinyName;
    }

    public String shinyShowText() {
        return shinyShowText;
    }

    @Override
    public String hash() {
        return suggest.hash();
    }

    @Override
    public String email() {
        return suggest.email();
    }

    @Override
    public String displayName() {
        return suggest.displayName();
    }

    @Override
    public long timestamp() {
        return suggest.timestamp();
    }

    @Override
    public int boost() {
        return suggest.boost();
    }

    @Override
    public String emailLow() {
        return suggest.emailLow();
    }

    @Override
    public int unreadCnt() {
        return suggest.unreadCnt();
    }

    @Override
    public String prefix() {
        return suggest.prefix();
    }

    @Override
    public Target target() {
        return suggest.target();
    }

    @Override
    public String showText() {
        return suggest.showText();
    }

    @Override
    public String searchText() {
        return suggest.searchText();
    }

    @Override
    public ContactSuggest withPrefix(final String prefix) {
        return new HighlightedContactSuggest(
            suggest.withPrefix(prefix),
            shinyEmail,
            shinyName);
    }

    @Override
    public void appendToWriter(final JsonWriterBase writer) throws IOException {
        suggest.appendToWriter(writer);

        writer.key(EMAIL_HIGHLIGHTED);
        writer.value(shinyEmail());
        writer.key(NAME_HIGHLIGHTED);
        writer.value(shinyName());
        writer.key(HighlightedSuggest.HIGHLIGHT);
        writer.value(shinyShowText());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            JsonWriter writer = new JsonWriter(new StringBuilderWriter(sb));
            writer.startObject();
            appendToWriter(writer);
            writer.endObject();
        } catch (IOException ioe) {
        }

        return sb.toString();
    }

    @Override
    public boolean filterable() {
        return suggest.filterable();
    }
}
