package ru.yandex.msearch.proxy.api.async.suggest.highlight;

import java.io.IOException;
import java.util.Map;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

public class HighlightedSuggest implements Suggest {
    public static final String HIGHLIGHT = "show_text_highlighted";
    private final Suggest suggest;
    private final String highlightedText;

    public HighlightedSuggest(
        final Suggest suggest,
        final String highlightedText)
    {
        this.suggest = suggest;
        this.highlightedText = highlightedText;
    }

    @Override
    public Target target() {
        return suggest.target();
    }

    @Override
    public String showText() {
        return suggest.showText();
    }

    @Override
    public String searchText() {
        return suggest.searchText();
    }

    @Override
    public Suggest withPrefix(final String prefix) {
        return new HighlightedSuggest(
            suggest.withPrefix(prefix),
            highlightedText);
    }

    @Override
    public double[] factors() {
        return suggest.factors();
    }

    @Override
    public Map<String, String> searchParams() {
        return suggest.searchParams();
    }

    @Override
    public void appendToWriter(final JsonWriterBase w) throws IOException {
        suggest.appendToWriter(w);
        w.key(HIGHLIGHT);
        w.value(highlightedText);
    }
}
