package ru.yandex.msearch.proxy.api.async.suggest.history;

import java.io.IOException;

import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.server.HttpServer;

import ru.yandex.json.writer.JsonValue;

import ru.yandex.parser.searchmap.User;

import ru.yandex.parser.uri.QueryConstructor;

public abstract class AbstractStoredRequest {
    public static final char SEPARATOR = '_';
    public static final String URL_PREFIX = "reqs" + SEPARATOR;

    protected final String raw;
    protected JsonValue prefix;

    public AbstractStoredRequest(final JsonValue prefix, final String raw) {
        this.raw = raw;
        this.prefix = prefix;
    }

    public String uri(final User user) throws BadRequestException {
        return uri(user, null, (String) null);
    }

    public String uri(
        final User user,
        final String proxyName,
        final HttpContext context)
        throws BadRequestException
    {
        String sessionId =
            (String) context.getAttribute(HttpServer.SESSION_ID);
        return uri(user, proxyName, sessionId);
    }

    protected QueryConstructor constructor(
        final User user,
        final String proxyName,
        final String sessionId) throws BadRequestException
    {
        QueryConstructor uri = new QueryConstructor(queryRoot());
        uri.append("service", user.service());
        uri.append("prefix", user.prefix().toString());
        uri.append("requestTs", System.currentTimeMillis());
        if (proxyName != null && sessionId != null) {
            uri.append(proxyName, sessionId);
        }
        if (raw != null) {
            uri.append("searchRequest", raw);
        }

        return uri;
    }

    public String uri(
        final User user,
        final String proxyName,
        final String sessionId) throws BadRequestException
    {
        return constructor(user, proxyName, sessionId).toString();
    }

    protected abstract String queryRoot();

    public abstract String toJsonString() throws IOException;

    public abstract String method();
}
