package ru.yandex.msearch.proxy.api.async.suggest.history;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.request.RequestHandlerMapper;

import ru.yandex.json.writer.JsonValue;

import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestText;

import ru.yandex.parser.searchmap.User;

import ru.yandex.parser.uri.QueryConstructor;

public final class DeleteStoredRequest extends AbstractStoredRequest {
    public static final String API_DELETE_ROUTE = "/delete";
    public static final String DELETE_QUERY_ROOT = API_DELETE_ROUTE + '?';

    private final String request;

    public DeleteStoredRequest(JsonValue prefix, String raw) {
        super(prefix, raw);
        String[] words =
            SuggestRequestText.buildParts(raw, SuggestRequestText.Trim.BOTH);
        List<String> wordsList = Arrays.asList(words);

        StringBuilder sb = new StringBuilder(
            StoredRequestFields.NORMALIZED.name());

        sb.append(':');
        request = StoredRequestFields.NORMALIZED
            .processForRequest(sb, wordsList).toString();
    }

    @Override
    protected QueryConstructor constructor(
        User user, String proxyName, String sessionId) throws
        BadRequestException
    {
        QueryConstructor uri = super.constructor(user, proxyName, sessionId);
        uri.append("text", request);
        return uri;
    }

    @Override
    public String toJsonString() throws IOException {
        return null;
    }

    @Override
    protected String queryRoot() {
        return DELETE_QUERY_ROOT;
    }

    @Override
    public String method() {
        return RequestHandlerMapper.GET;
    }
}
