package ru.yandex.msearch.proxy.api.async.suggest.history;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggests;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.lang.SuggestLanguagePack;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;
import ru.yandex.msearch.proxy.api.async.suggest.contact.BasicContactSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.contact.QLContactSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.united.AdapterCallback;
import ru.yandex.msearch.proxy.api.async.suggest.united.DefaultSuggestAdapter;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

import ru.yandex.msearch.proxy.api.async.suggest.united.UnitedSuggests;
import ru.yandex.msearch.proxy.config.ImmutableMsearchProxyConfig;

import ru.yandex.msearch.proxy.config.ImmutableSuggestConfig;
import ru.yandex.stater.RequestsStater;

public class HistorySuggestAdapter extends DefaultSuggestAdapter {
    private static final Pattern TO_PATTERN =
        Pattern.compile("\\s*(?:to|кому):[\\s]?([^\\s]+)");
    private static final Pattern FROM_PATTERN =
        Pattern.compile("\\s*(?:from|от):[\\s]?([^\\s]+)");

    private final ImmutableSuggestConfig config;

    public HistorySuggestAdapter(
        final ImmutableMsearchProxyConfig config,
        final SuggestRule<Suggests<? extends Suggest>> next)
    {
        super(config, next, Target.HISTORY);

        this.config = config.suggestConfig();
    }

    @Override
    protected AdapterCallback<Suggests<? extends Suggest>> callback(
        final SuggestRequest<UnitedSuggests> request,
        final FutureCallback<Suggests<? extends Suggest>> callback)
    {
        return new HistoryAdapterCallback(
            callback,
            request.requestParams().language(),
            stater);
    }

    private class HistoryAdapterCallback
        extends AdapterCallback<Suggests<? extends Suggest>>
    {
        private final SuggestLanguagePack languagePack;
        public HistoryAdapterCallback(
            final FutureCallback<Suggests<? extends Suggest>> callback,
            final SuggestLanguagePack languagePack,
            final RequestsStater stater)
        {
            super(callback, stater);

            this.languagePack = languagePack;
        }

        /**
         * Replaces all from:x and to:x in history
         * with corresponding contact suggests
         *
         * @return
         */
        private Suggests<? extends Suggest> replaceContacts(
            final Suggests<? extends Suggest> suggests)
        {
            BasicSuggests modified =
                new BasicSuggests(Target.HISTORY, suggests.size());

            for (Suggest suggest : suggests) {
                Matcher fromMatcher =
                    FROM_PATTERN.matcher(suggest.searchText());
                Matcher toMatcher =
                    TO_PATTERN.matcher(suggest.searchText());

                if (fromMatcher.matches()) {
                    String email = fromMatcher.group(1);

                    modified.add(
                        new QLContactSuggest(
                            Target.CONTACT,
                            new BasicContactSuggest(email, email, 0, 0),
                            this.languagePack));
                } else if (toMatcher.matches()) {
                    String email = toMatcher.group(1);

                    modified.add(
                        new QLContactSuggest(
                            Target.CONTACT,
                            new BasicContactSuggest(email, email, 0, 0),
                            this.languagePack));
                } else {
                    modified.add(suggest);
                }
            }

            return modified;
        }

        @Override
        public void completed(final Suggests<? extends Suggest> result) {
            if (config.historyToContacts()) {
                super.completed(replaceContacts(result));
            } else {
                super.completed(result);
            }
        }
    }
}
