package ru.yandex.msearch.proxy.api.async.suggest.history;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.BasicAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.prefix.LongPrefix;

public class HistorySuggestCleanupHandler implements ProxyRequestHandler {
    private final AsyncHttpServer proxy;

    public HistorySuggestCleanupHandler(final AsyncHttpServer proxy) {
        this.proxy = proxy;
    }

    @Override
    public void handle(
        final ProxySession session)
        throws HttpException, IOException
    {
        Long uid = session.params().getLong(ProxyParams.UID);
        LongPrefix prefix = new LongPrefix(uid);
        boolean all = session.params().getBoolean("all", false);
        User user = new User(proxy.resolveService("pg", prefix), prefix);

        AsyncClient client =
            proxy.producerStoreClient().adjust(session.context());
        if (!all) {
            String request =
                session.params().getString(ProxyParams.REQUEST);
            QueryConstructor qc =
                new QueryConstructor(
                    "/delete?msproxy_history_cleanup_single");
            qc.append("prefix", prefix.toStringFast());
            qc.append("service", user.service());
            qc.append("request_text", request);

            StringBuilderWriter sbw = new StringBuilderWriter();
            try (JsonWriter jw = JsonType.NORMAL.create(sbw)) {
                jw.startObject();
                jw.key("prefix");
                jw.value(prefix.toStringFast());
                jw.key("docs");
                jw.startArray();
                jw.startObject();
                jw.key("url");
                jw.value("reqs_" + prefix.toStringFast() + '_' + request);
                jw.endObject();
                jw.endArray();
                jw.endObject();
            }

            BasicAsyncRequestProducerGenerator generator =
                new BasicAsyncRequestProducerGenerator(
                    qc.toString(),
                    sbw.toString());

            client.execute(
                proxy.config().producerStoreConfig().host(),
                generator,
                BasicAsyncResponseConsumerFactory.ANY_GOOD,
                session.listener().adjustContextGenerator(
                    client.httpClientContextGenerator()),
                new HistoryCleanupCallback(session));
        } else {
            QueryConstructor qc =
                new QueryConstructor(
                    "/delete?msproxy_history_cleanup_all");
            qc.append("prefix", prefix.toStringFast());
            qc.append("service", user.service());
            qc.append("text", "request_normalized:*");
            client.execute(
                proxy.config().producerStoreConfig().host(),
                    new BasicAsyncRequestProducerGenerator(qc.toString()),
                BasicAsyncResponseConsumerFactory.ANY_GOOD,
                session.listener().adjustContextGenerator(
                    client.httpClientContextGenerator()),
                new HistoryCleanupCallback(session));
        }
    }

    private static final class HistoryCleanupCallback
        extends AbstractProxySessionCallback<Object>
    {
        public HistoryCleanupCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Object o) {
            session.response(HttpStatus.SC_OK);
        }
    }
}
