package ru.yandex.msearch.proxy.api.async.suggest.history;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestPrinter;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestSession;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;

import ru.yandex.msearch.proxy.api.async.suggest.history.rules
    .HistoryRewriteSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.history.rules
    .HistorySuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.history.rules
    .PlainHistorySuggestRule;

import ru.yandex.msearch.proxy.api.async.suggest.rules.LegacyFormatSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.rules
    .ParallelTranslitSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.rules.ResolveUserRule;
import ru.yandex.msearch.proxy.api.async.suggest.rules.TranslitSuggestRule;

import ru.yandex.msearch.proxy.api.async.suggest.subject.rules
    .PlainSubjectSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.subject.rules.SubjectRewriteSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.subject.rules.SubjectSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.united.SuggestAdapter;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

import ru.yandex.msearch.proxy.config.ImmutableSubjectSuggestConfig;
import ru.yandex.msearch.proxy.config.ImmutableSuggestConfig;

/**
 * Handler for providing history suggests service
 */
public class HistorySuggestHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    public static final String LOG_PREFIX = "history-suggests";

    private final AsyncHttpServer server;
    private final SuggestRule<Suggests<? extends Suggest>> rule;

    public HistorySuggestHandler(final AsyncHttpServer server) {
        this.server = server;
        this.rule = createMixedRule(server);
    }

    private static SuggestRule<Suggests<? extends Suggest>> createMixedRule(
        final AsyncHttpServer server)
    {
        ImmutableSuggestConfig suggestConfig =
            server.config().suggestConfig();
        ImmutableSubjectSuggestConfig config =
            suggestConfig.subjectConfig();

        SuggestRule<Suggests<? extends Suggest>> subjectRule =
            new PlainSubjectSuggestRule(server);

        subjectRule = new SubjectRewriteSuggestRule(config, subjectRule);
        subjectRule =
            new ParallelTranslitSuggestRule(
                subjectRule,
                suggestConfig.translitOriginalMandatory());

        subjectRule = new SubjectSuggestRule(subjectRule, config);

        SuggestRule<Suggests<? extends Suggest>> historyRule = new
            PlainHistorySuggestRule(
            server);
        historyRule = new HistoryRewriteSuggestRule(historyRule);
        historyRule = new TranslitSuggestRule<>(historyRule);
        historyRule = new HistorySuggestRule(server, historyRule);
        SuggestRule<Suggests<? extends Suggest>> rule =
            new MixedHistorySuggestRule(historyRule, subjectRule);

        rule = new ResolveUserRule<>(rule, server);
        return new LegacyFormatSuggestRule(config, rule);
    }

    private static SuggestRule<Suggests<? extends Suggest>> createRule(
        final AsyncHttpServer server)
    {
        ImmutableSuggestConfig suggestConfig =
            server.config().suggestConfig();
        ImmutableSubjectSuggestConfig config =
            suggestConfig.subjectConfig();

        SuggestRule<Suggests<? extends Suggest>> rule =
            new PlainHistorySuggestRule(server);

        rule = new HistoryRewriteSuggestRule(rule);
        //rule = new TranslitSuggestRule<>(rule);
        rule = new ParallelTranslitSuggestRule(
            rule,
            suggestConfig.translitOriginalMandatory());
        rule = new HistorySuggestRule(server, rule);
        rule = new ResolveUserRule<>(rule, server);
        return new LegacyFormatSuggestRule(config, rule);
    }

    public static SuggestAdapter createAdapter(final AsyncHttpServer server) {
        SuggestRule<Suggests<? extends Suggest>> rule = createRule(server);
        return new HistorySuggestAdapter(server.config(), rule);
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        SuggestSession session = new SuggestSession(server, exchange, context);

        SuggestRequestParams params =
            new BasicSuggestRequestParams(Target.HISTORY);

        SuggestPrinter printer =
            new SuggestPrinter(server, session, params);

        SuggestRequest<Suggests<? extends Suggest>> suggestRequest =
            new BasicSuggestRequest<>(
                session,
                params,
                printer,
                LOG_PREFIX);

        rule.execute(suggestRequest);
    }

    @Override
    public String toString() {
        return "Provides suggests for mail search";
    }
}
