package ru.yandex.msearch.proxy.api.async.suggest.history;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import org.apache.http.concurrent.FutureCallback;

import org.apache.http.entity.ContentType;

import ru.yandex.http.proxy.AbstractProxySessionCallback;

import ru.yandex.http.proxy.ProxyRequestHandler;

import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.BasicAsyncResponseConsumerFactory;

import ru.yandex.http.util.nio.client.AsyncClient;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.ProxyParams;

import ru.yandex.parser.searchmap.User;

import ru.yandex.search.prefix.LongPrefix;

/**
 * Ability to force store user request in history
 */
public class StoreHistorySuggestHandler implements ProxyRequestHandler {
    private final AsyncHttpServer server;

    public StoreHistorySuggestHandler(final AsyncHttpServer server) {
        this.server = server;
    }

    @Override
    public void handle(
        final ProxySession session)
        throws HttpException, IOException
    {
        Long uid = session.params().getLong(ProxyParams.UID);
        String request = session.params().getString(ProxyParams.REQUEST);
        String mid = session.params().getString("mid", null);

        AsyncClient client =
            server.producerStoreClient().adjust(session.context());
        LongPrefix prefix = new LongPrefix(uid);
        User user = new User(
            AsyncHttpServer.resolveService(
                ProxyParams.PG,
                prefix,
                server.config()),
            prefix);

        AbstractStoredRequest storeRequest =
            new UpdateStoredRequest(prefix, request, mid);

        // ok, for faster indexation we always store request in index
        // after request completed, we will delete it
        FutureCallback<Object> producerCallback = new StoreCallback(session);
        try {
            client.execute(
                server.config().producerStoreConfig().host(),
                new BasicAsyncRequestProducerGenerator(
                    storeRequest.uri(
                        user,
                        "search_as_you_type",
                        session.context()),
                    storeRequest.toJsonString(),
                    ContentType.APPLICATION_JSON),
                BasicAsyncResponseConsumerFactory.ANY_GOOD,
                session.listener().adjustContextGenerator(
                    client.httpClientContextGenerator()),
                producerCallback);
        } catch (IOException e) {
            producerCallback.failed(e);
        }
    }

    private static class StoreCallback
        extends AbstractProxySessionCallback<Object>
    {
        public StoreCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Object o) {
            session.response(HttpStatus.SC_OK);
        }
    }
}
