package ru.yandex.msearch.proxy.api.async.suggest.history;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.http.util.request.RequestHandlerMapper;

import ru.yandex.io.StringBuilderWriter;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriter;

import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestText;

public class UpdateStoredRequest extends AbstractStoredRequest {
    public static final String API_SAVE_ROUTE = "/update";
    public static final String SAVE_QUERY_ROOT = API_SAVE_ROUTE + '?';

    private final long timestamp;
    private final String spaceless;
    private final String normalized;
    private final String mid;
    private String corrected = null;
    private String suggest = null;

    public UpdateStoredRequest(final JsonValue prefix, final String raw) {
        this(prefix, raw, null);
    }

    public UpdateStoredRequest(
        final JsonValue prefix,
        final String raw,
        final String mid)
    {
        super(prefix, raw);

        this.mid = mid;
        this.timestamp = System.currentTimeMillis() / 1000;
        String[] words =
            SuggestRequestText.buildParts(raw, SuggestRequestText.Trim.BOTH);
        List<String> wordsList = Arrays.asList(words);
        this.normalized = StoredRequestFields.NORMALIZED
            .processForStore(wordsList);
        this.spaceless = StoredRequestFields.SPACELESS
            .processForStore(wordsList);
    }

    public void corrected(final String corrected) {
        this.corrected = corrected;
    }

    public void suggest(final String suggest) {
        this.suggest = suggest;
    }

    public String toJsonString() throws IOException {
        StringBuilderWriter sbWriter = new StringBuilderWriter();
        try (JsonWriter writer = new JsonWriter(sbWriter)) {
            writer.startObject();
            writer.key("prefix");
            writer.value(prefix);
            writer.key("AddIfNotExists");
            writer.value(true);
            writer.key("docs");
            writer.startArray();
            writer.startObject();
            writer.key("url");
            // Url supposed to be primary key
            // making it unique
            // concatenating here not supposed to be too heavy

            writer.value(
                AbstractStoredRequest.URL_PREFIX + prefix
                    + AbstractStoredRequest.SEPARATOR + raw);

            writer.key("type");
            writer.value("mail_request_history");

            writer.key(StoredRequestFields.RAW.name());
            writer.value(raw);

            writer.key(StoredRequestFields.ORIGINAL.name());
            writer.value(corrected);

            writer.key(StoredRequestFields.SUGGESTED.name());
            writer.value(suggest);

            writer.key(StoredRequestFields.NORMALIZED.name());
            writer.value(normalized);

            writer.key(StoredRequestFields.SPACELESS.name());
            writer.value(spaceless);

            if (mid != null) {
                writer.key(MailIndexFields.REQUEST_MIDS);
                writer.value(mid);
            }

            writer.key(StoredRequestFields.COUNT.name());
            writer.startObject();
            writer.key("function");
            writer.value("inc");
            writer.endObject();

            writer.key(StoredRequestFields.DATE.name());
            writer.value(timestamp);

            writer.endObject();
            writer.endArray();
            writer.endObject();
        }
        String result = sbWriter.toString();
        return result;
    }

    @Override
    public String method() {
        return RequestHandlerMapper.POST;
    }

    @Override
    protected String queryRoot() {
        return SAVE_QUERY_ROOT;
    }
}
