package ru.yandex.msearch.proxy.api.async.suggest.history.rules;

import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggests;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;
import ru.yandex.msearch.proxy.config.ImmutableSubjectSuggestConfig;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

/**
 * Root rule for history suggest service
 *
 */
public class HistorySuggestRule
    implements SuggestRule<Suggests<? extends Suggest>>
{
    private static final Map<String, String> FIELD_MAP = new HashMap<>();
    private static final String DEFAULT_SORT_FIELD = "request_date";

    static {
        FIELD_MAP.put("req_timestamp", "request_date");
    }

    private final SuggestRule<Suggests<? extends Suggest>> next;
    private final ImmutableSubjectSuggestConfig config;

    public HistorySuggestRule(
        final AsyncHttpServer server,
        final SuggestRule<Suggests<? extends Suggest>> next)
    {
        this.next = next;
        this.config = server.config().suggestConfig().subjectConfig();
    }

    @Override
    public void execute(
        final SuggestRequest<Suggests<? extends Suggest>> request)
        throws HttpException
    {
        CgiParams params = new CgiParams(request.cgiParams());

        Boolean responseOnEmpty = params.getBoolean("empty", null);
        if (responseOnEmpty == null) {
            params.replace("empty", String.valueOf(config.responseOnEmpty()));
        }

        if (params.getString("sort_fields", null) == null) {
            String how = params.getString("how", null);
            if (how != null) {
                params.replace("sort_fields", FIELD_MAP.get(how));
            } else {
                params.replace("sort_fields", DEFAULT_SORT_FIELD);
            }
        }

        SuggestRequestParams requestParams =
            new BasicSuggestRequestParams(
                request.requestParams(),
                params,
                true,
                config.limit());

        next.execute(request.with(params, requestParams));
    }
}
