package ru.yandex.msearch.proxy.api.async.suggest.history.rules;

import org.apache.http.HttpException;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.Session;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestLuceneRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;
import ru.yandex.msearch.proxy.api.async.suggest.rules
    .AbstractPlainSuggestCallback;
import ru.yandex.msearch.proxy.api.async.suggest.rules.PlainSuggestRule;

/**
 * TokenizeRule for actual search in users request history
 *
 */
public class PlainHistorySuggestRule
    extends PlainSuggestRule<Suggests<? extends Suggest>>
{
    public PlainHistorySuggestRule(final AsyncHttpServer server) {
        super(server);
    }

    @Override
    public AbstractPlainSuggestCallback<Suggests<? extends Suggest>> createCallback(
        final AsyncHttpServer server,
        final SuggestLuceneRequest searchRequest,
        final SuggestRequest<Suggests<? extends Suggest>> suggestRequest)
        throws HttpException
    {
        return new PlainHistorySuggestCallback(
            server,
            searchRequest,
            suggestRequest);
    }

    @Override
    public PrefixedLogger logger(final Session session) {
        return session.logger().addPrefix("history-suggest");
    }
}
