package ru.yandex.msearch.proxy.api.async.suggest.label;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

public class LabelSuggest extends BasicSuggest {
    private static final String LID = "lid";

    private final String lids;

    public LabelSuggest(
        final String showText,
        final String searchText,
        final String lids)
    {
        this(Target.LABEL, showText, searchText, Collections.emptyMap(), lids);
    }

    public LabelSuggest(
        final Target target,
        final String showText,
        final String searchText,
        final String lids)
    {
        this(target, showText, searchText, Collections.emptyMap(), lids);
    }

    public LabelSuggest(
        final Target target,
        final String showText,
        final String searchText,
        final Map<String, String> params,
        final String lids)
    {
        super(target, showText, searchText, params);

        this.lids = lids;
    }

    public String lids() {
        return lids;
    }

    @Override
    public Suggest withPrefix(
        final String prefix)
    {
        return new LabelSuggest(
            target(),
            showText(),
            prefix + searchText(),
            searchParams,
            lids());
    }

    @Override
    public void appendToWriter(final JsonWriterBase writer)
        throws IOException
    {
        super.appendToWriter(writer);
        writer.key(LID);
        writer.value(lids);
    }
}
