package ru.yandex.msearch.proxy.api.async.suggest.label;

import java.io.IOException;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestPrinter;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestSession;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;
import ru.yandex.msearch.proxy.api.async.suggest.rules.MultiwordSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.rules.ResolveUserRule;
import ru.yandex.msearch.proxy.api.async.suggest.rules.TranslitSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.united.DefaultSuggestAdapter;
import ru.yandex.msearch.proxy.api.async.suggest.united.SuggestAdapter;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;
import ru.yandex.msearch.proxy.api.async.suggest.united.UnitedSuggestPrinter;

public class LabelSuggestHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    public static final String LOG_PREFIX = "label-suggests";

    private final AsyncHttpServer server;
    private final SuggestRule<Suggests<? extends Suggest>> rule;

    public LabelSuggestHandler(
        final AsyncHttpServer server)
    {
        this.server = server;

        this.rule = createRule(server);
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context) throws HttpException, IOException
    {
        SuggestSession session = new SuggestSession(server, exchange, context);

        Header enabledBoxed =
            session.request().getFirstHeader(YandexHeaders.X_ENABLED_BOXES);

        String experimentsString = null;
        if (enabledBoxed != null) {
            experimentsString = enabledBoxed.getValue();
        }

        SuggestRequestParams params = new BasicSuggestRequestParams(
            Target.LABEL,
            session.params(),
            BasicSuggestRequestParams.parseExperiments(experimentsString),
            server.config().suggestConfig().limit());

        BasicSuggestPrinter<Suggests<? extends Suggest>> printer =
            new BasicSuggestPrinter<>(server, session, LOG_PREFIX);

        SuggestRequest<Suggests<? extends Suggest>> suggestRequest =
            new BasicSuggestRequest<>(
                session,
                params,
                printer,
                LOG_PREFIX);

        rule.execute(suggestRequest);
    }

    private static SuggestRule<Suggests<? extends Suggest>> createRule(
        final AsyncHttpServer server)
    {
        SuggestRule<Suggests<? extends Suggest>> rule =
            new LabelSuggestRule(server);

        rule = new TranslitSuggestRule<>(rule);
        rule = new MultiwordSuggestRule<>(rule);

        return new ResolveUserRule<>(rule, server);
    }

    public static SuggestAdapter createAdapter(final AsyncHttpServer server) {
        SuggestRule<Suggests<? extends Suggest>> rule = createRule(server);
        return new DefaultSuggestAdapter(server.config(), rule, Target.LABEL);
    }

    @Override
    public String toString() {
        return "Provides label suggests for mail search";
    }
}
