package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Армянский
 */
public class ArmenianSuggestLanguagePack extends BaseSuggestLanguagePack {
    public static final ArmenianSuggestLanguagePack INSTANCE
        = new ArmenianSuggestLanguagePack();

    private static final String ID = "hy";

    private static final Map<String, String> EN_SYSTEM_FOLDERS;
    private static final Map<String, String> EN_SYSTEM_LABELS;

    static {
        Map<String, String> map = new HashMap<>();
        //map.put("Flagged", "FAKE_SEEN_LBL");
        map.put("Read", "FAKE_SEEN_LBL");

        EN_SYSTEM_LABELS = Collections.unmodifiableMap(map);

        Map<String, String> foldersMap = new HashMap<>();

        foldersMap.put(INBOX, "Մուտքային");
        foldersMap.put(SENT, "Ուղարկված");
        foldersMap.put(DRAFT, "Սևագրեր");
        foldersMap.put(SPAM, "Սևագրեր");
        foldersMap.put(OUTBOX, "Ելքային");
        foldersMap.put(TRASH, "Հեռացված");

        EN_SYSTEM_FOLDERS = Collections.unmodifiableMap(foldersMap);
    }

    public ArmenianSuggestLanguagePack() {
        super();

        for (QL ql: QL.values()) {
            add(ql, ql.value());
        }
    }

    @Override
    public Map<String, String> systemLabels() {
        return EN_SYSTEM_LABELS;
    }

    @Override
    public Map<String, String> systemFolders() {
        return EN_SYSTEM_FOLDERS;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String unreadLabel() {
        return "Չընթերցված";
    }

    @Override
    public String importantLabel() {
        return "Կարևոր";
    }
}