package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AzerbaijaniSuggestLanguagePack extends BaseSuggestLanguagePack {
    public static final AzerbaijaniSuggestLanguagePack INSTANCE
        = new AzerbaijaniSuggestLanguagePack();

    private static final String ID = "az";

    private static final Map<String, String> SYSTEM_FOLDERS;
    private static final Map<String, String> SYSTEM_LABELS;

    static {
        Map<String, String> map = new HashMap<>();
        //map.put("Flagged", "FAKE_SEEN_LBL");
        map.put("Read", "FAKE_SEEN_LBL");

        SYSTEM_LABELS = Collections.unmodifiableMap(map);

        Map<String, String> foldersMap = new HashMap<>();

        foldersMap.put(INBOX, "Daxil olanlar");
        foldersMap.put(SENT, "Göndərilənlər");
        foldersMap.put(DRAFT, "Qaralamalar");
        foldersMap.put(SPAM, "Spam");
        foldersMap.put(OUTBOX, "Çıxış qutusu");
        foldersMap.put(TRASH, "Silinənlər");

        SYSTEM_FOLDERS = Collections.unmodifiableMap(foldersMap);
    }

    public AzerbaijaniSuggestLanguagePack() {
        super();

        for (QL ql: QL.values()) {
            add(ql, ql.value());
        }
    }

    @Override
    public Map<String, String> systemLabels() {
        return SYSTEM_LABELS;
    }

    @Override
    public Map<String, String> systemFolders() {
        return SYSTEM_FOLDERS;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String unreadLabel() {
        return "Oxunmamış";
    }

    @Override
    public String importantLabel() {
        return "Vacib";
    }
}