package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseSuggestLanguagePack implements SuggestLanguagePack {
    protected final Map<String, List<QL>> qlInvertedMap;
    protected final EnumMap<QL, String> qlEnumMap;

    public BaseSuggestLanguagePack() {
        this.qlInvertedMap = new HashMap<>();
        this.qlEnumMap = new EnumMap<>(QL.class);
    }

    protected void add(final QL key, final String value) {
        this.qlEnumMap.put(key, value);

        List<QL> keys = qlInvertedMap.get(value);
        if (keys == null) {
            keys = new ArrayList<>();
            qlInvertedMap.put(value, keys);
        }

        keys.add(key);
    }

    @Override
    public String ql(final String key) {
        if(key == null) {
            return null;
        } else {
            try {
                return qlEnumMap.get(QL.valueOf(key));
            } catch (IllegalArgumentException var3) {
                return null;
            }
        }
    }

    @Override
    public String ql(final QL key) {
        return qlEnumMap.get(key);
    }

    @Override
    public String label() {
        return qlEnumMap.get(QL.LABEL);
    }

    @Override
    public String folder() {
        return qlEnumMap.get(QL.FOLDER);
    }

    @Override
    public String filter() {
        return qlEnumMap.get(QL.FILTER);
    }

    public List<QL> keys(final String token) {
        return qlInvertedMap.get(token);
    }

    @Override
    public QL key(final String token) {
        List<QL> keys = keys(token);
        if (keys == null || keys.isEmpty()) {
            return null;
        }

        return keys.get(0);
    }

    @Override
    public Collection<String> values() {
        return qlEnumMap.values();
    }

    @Override
    public List<String> months() {
        return EnSuggestLanguagePack.INSTANCE.months();
    }

    @Override
    public List<String> longMonths() {
        return EnSuggestLanguagePack.INSTANCE.longMonths();
    }
}
