package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BelarusianSuggestLanguagePack extends BaseSuggestLanguagePack {
    public static final BelarusianSuggestLanguagePack INSTANCE
        = new BelarusianSuggestLanguagePack();

    private static final String ID = "be";

    private static final Map<String, String> SYSTEM_FOLDERS;
    private static final Map<String, String> SYSTEM_LABELS;

    static {
        Map<String, String> map = new HashMap<>();
        //map.put("Flagged", "FAKE_SEEN_LBL");
        map.put("Read", "FAKE_SEEN_LBL");

        SYSTEM_LABELS = Collections.unmodifiableMap(map);

        Map<String, String> foldersMap = new HashMap<>();

        foldersMap.put(INBOX, "Уваходныя");
        foldersMap.put(SENT, "Адасланыя");
        foldersMap.put(DRAFT, "Чарнавікі");
        foldersMap.put(SPAM, "Спам");
        foldersMap.put(OUTBOX, "Зыходныя");
        foldersMap.put(TRASH, "Выдаленыя");

        SYSTEM_FOLDERS = Collections.unmodifiableMap(foldersMap);
    }

    public BelarusianSuggestLanguagePack() {
        super();

        for (QL ql: QL.values()) {
            add(ql, ql.value());
        }
    }

    @Override
    public Map<String, String> systemLabels() {
        return SYSTEM_LABELS;
    }

    @Override
    public Map<String, String> systemFolders() {
        return SYSTEM_FOLDERS;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String unreadLabel() {
        return "Непрачытаныя";
    }

    @Override
    public String importantLabel() {
        return "Важныя";
    }
}