package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnSuggestLanguagePack extends BaseSuggestLanguagePack {
    public static final EnSuggestLanguagePack INSTANCE
        = new EnSuggestLanguagePack();

    private static final String ID = "en";

    private static final Map<String, String> EN_SYSTEM_FOLDERS;
    private static final Map<String, String> EN_SYSTEM_LABELS;
    private static final List<String> MONTHS;
    private static final List<String> LONG_MONTHS;

    static {
        Map<String, String> map = new HashMap<>();
        //map.put("Flagged", "FAKE_SEEN_LBL");
        map.put("Read", "FAKE_SEEN_LBL");

        EN_SYSTEM_LABELS = Collections.unmodifiableMap(map);

        Map<String, String> foldersMap = new HashMap<>();

        foldersMap.put(INBOX, "Inbox");
        foldersMap.put(SENT, "Sent");
        foldersMap.put(DRAFT, "Drafts");
        foldersMap.put(SPAM, "Spam");
        foldersMap.put(OUTBOX, "Outbox");
        foldersMap.put(TRASH, "Trash");

        EN_SYSTEM_FOLDERS = Collections.unmodifiableMap(foldersMap);

        MONTHS = new ArrayList<>(12);
        MONTHS.add("jan");
        MONTHS.add("feb");
        MONTHS.add("mar");
        MONTHS.add("apr");
        MONTHS.add("may");
        MONTHS.add("jun");
        MONTHS.add("jul");
        MONTHS.add("aug");
        MONTHS.add("sep");
        MONTHS.add("oct");
        MONTHS.add("nov");
        MONTHS.add("dec");

        LONG_MONTHS = new ArrayList<>(12);
        LONG_MONTHS.add("january");
        LONG_MONTHS.add("february");
        LONG_MONTHS.add("march");
        LONG_MONTHS.add("april");
        LONG_MONTHS.add("may");
        LONG_MONTHS.add("june");
        LONG_MONTHS.add("july");
        LONG_MONTHS.add("august");
        LONG_MONTHS.add("september");
        LONG_MONTHS.add("october");
        LONG_MONTHS.add("november");
        LONG_MONTHS.add("december");
    }

    public EnSuggestLanguagePack() {
        super();

        for (QL ql: QL.values()) {
            add(ql, ql.value());
        }
    }

    @Override
    public Map<String, String> systemLabels() {
        return EN_SYSTEM_LABELS;
    }

    @Override
    public Map<String, String> systemFolders() {
        return EN_SYSTEM_FOLDERS;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String unreadLabel() {
        return "Unread";
    }

    @Override
    public String importantLabel() {
        return "Flagged";
    }

    @Override
    public List<String> months() {
        return MONTHS;
    }

    @Override
    public List<String> longMonths() {
        return LONG_MONTHS;
    }
}
