package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GeorgianSuggestLanguagePack extends BaseSuggestLanguagePack {
    public static final GeorgianSuggestLanguagePack INSTANCE
        = new GeorgianSuggestLanguagePack();

    private static final String ID = "ka";

    private static final Map<String, String> SYSTEM_FOLDERS;
    private static final Map<String, String> SYSTEM_LABELS;

    static {
        Map<String, String> map = new HashMap<>();
        //map.put("Flagged", "FAKE_SEEN_LBL");
        map.put("Read", "FAKE_SEEN_LBL");

        SYSTEM_LABELS = Collections.unmodifiableMap(map);

        Map<String, String> foldersMap = new HashMap<>();

        foldersMap.put(INBOX, "შემოსულები");
        foldersMap.put(SENT, "გაგზავნილები");
        foldersMap.put(TRASH, "წაშლილები");
        foldersMap.put(SPAM, "სპამი");
        foldersMap.put(DRAFT, "მონახაზები");
        foldersMap.put(OUTBOX, "გასაგზავნები");


        SYSTEM_FOLDERS = Collections.unmodifiableMap(foldersMap);
    }

    public GeorgianSuggestLanguagePack() {
        super();

        for (QL ql: QL.values()) {
            add(ql, ql.value());
        }
    }

    @Override
    public Map<String, String> systemLabels() {
        return SYSTEM_LABELS;
    }

    @Override
    public Map<String, String> systemFolders() {
        return SYSTEM_FOLDERS;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String unreadLabel() {
        return "წაუკითხავი";
    }

    @Override
    public String importantLabel() {
        return "მნიშვნელოვანი";
    }
}