package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class KazakhSuggestLanguagePack extends BaseSuggestLanguagePack {
    public static final KazakhSuggestLanguagePack INSTANCE
        = new KazakhSuggestLanguagePack();

    private static final String ID = "kk";

    private static final Map<String, String> SYSTEM_FOLDERS;
    private static final Map<String, String> SYSTEM_LABELS;

    static {
        Map<String, String> map = new HashMap<>();
        //map.put("Flagged", "FAKE_SEEN_LBL");
        map.put("Read", "FAKE_SEEN_LBL");

        SYSTEM_LABELS = Collections.unmodifiableMap(map);

        Map<String, String> foldersMap = new HashMap<>();

        foldersMap.put(INBOX, "Кіріс");
        foldersMap.put(SENT, "Шығыс");
        foldersMap.put(TRASH, "Жойылғандар");
        foldersMap.put(SPAM, "Спам");
        foldersMap.put(DRAFT, "Жобалар");
        foldersMap.put(OUTBOX, "Шыққандар");


        SYSTEM_FOLDERS = Collections.unmodifiableMap(foldersMap);
    }

    public KazakhSuggestLanguagePack() {
        super();

        for (QL ql: QL.values()) {
            add(ql, ql.value());
        }
    }

    @Override
    public Map<String, String> systemLabels() {
        return SYSTEM_LABELS;
    }

    @Override
    public Map<String, String> systemFolders() {
        return SYSTEM_FOLDERS;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String unreadLabel() {
        return "Оқылмағандар";
    }

    @Override
    public String importantLabel() {
        return "Маңыздылар";
    }
}
