package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RomanSuggestLanguagePack extends BaseSuggestLanguagePack {
    public static final RomanSuggestLanguagePack INSTANCE
        = new RomanSuggestLanguagePack();

    private static final String ID = "ro";

    private static final Map<String, String> SYSTEM_FOLDERS;
    private static final Map<String, String> SYSTEM_LABELS;

    static {
        Map<String, String> map = new HashMap<>();
        //map.put("Flagged", "FAKE_SEEN_LBL");
        map.put("Read", "FAKE_SEEN_LBL");

        SYSTEM_LABELS = Collections.unmodifiableMap(map);

        Map<String, String> foldersMap = new HashMap<>();

        foldersMap.put(INBOX, "Mesaje primite");
        foldersMap.put(SENT, "Mesaje trimise");
        foldersMap.put(TRASH, "Șterse");
        foldersMap.put(SPAM, "Spam");
        foldersMap.put(DRAFT, "Ciorne");
        foldersMap.put(OUTBOX, "Mesaje în curs de trimitere");


        SYSTEM_FOLDERS = Collections.unmodifiableMap(foldersMap);
    }

    public RomanSuggestLanguagePack() {
        super();

        for (QL ql: QL.values()) {
            add(ql, ql.value());
        }
    }

    @Override
    public Map<String, String> systemLabels() {
        return SYSTEM_LABELS;
    }

    @Override
    public Map<String, String> systemFolders() {
        return SYSTEM_FOLDERS;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String unreadLabel() {
        return "Mesaje necitite";
    }

    @Override
    public String importantLabel() {
        return "Importante";
    }
}