package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuSuggestLanguagePack extends BaseSuggestLanguagePack {
    public static final RuSuggestLanguagePack INSTANCE =
        new RuSuggestLanguagePack();

    private static final String ID = "ru";

    private static final Map<String, String> RU_SYSTEM_FOLDERS;
    private static final Map<String, String> RU_SYSTEM_LABELS =
                Collections.singletonMap("Прочитанные", "FAKE_SEEN_LBL");
    private static final List<String> MONTHS;
    private static final List<String> LONG_MONTHS;

    static {
        Map<String, String> folders = new HashMap<>();
        folders.put(INBOX, "Входящие");
        folders.put(SENT, "Отправленные");
        //folders.put(DRAFT, "Черновики");
        //folders.put(OUTBOX, "Исходящие");
        //folders.put(SPAM, "Спам");
        //folders.put(TRASH, "Удалённые");
        RU_SYSTEM_FOLDERS = Collections.unmodifiableMap(folders);

        MONTHS = new ArrayList<>(12);
        MONTHS.add("янв");
        MONTHS.add("фев");
        MONTHS.add("мар");
        MONTHS.add("апр");
        MONTHS.add("май");
        MONTHS.add("июн");
        MONTHS.add("июл");
        MONTHS.add("авг");
        MONTHS.add("сен");
        MONTHS.add("окт");
        MONTHS.add("ноя");
        MONTHS.add("дек");

        LONG_MONTHS = new ArrayList<>(12);
        LONG_MONTHS.add("январь");
        LONG_MONTHS.add("февраль");
        LONG_MONTHS.add("март");
        LONG_MONTHS.add("апрель");
        LONG_MONTHS.add("май");
        LONG_MONTHS.add("июнь");
        LONG_MONTHS.add("июль");
        LONG_MONTHS.add("август");
        LONG_MONTHS.add("сентябрь");
        LONG_MONTHS.add("октябрь");
        LONG_MONTHS.add("ноябрь");
        LONG_MONTHS.add("декабрь");
    }

    public RuSuggestLanguagePack() {
        super();

        add(QL.FROM, "от");
        add(QL.TO, "кому");
        add(QL.CC, "копия");
        add(QL.BCC, "скрытая-копия");
        add(QL.TYPE, "тип");
        add(QL.SUBJECT, "тема");
        add(QL.TEXT, "текст");
        add(QL.FILTER, "фильтр");
        add(QL.LABEL, "метка");
        add(QL.FOLDER, "папка");
        add(QL.ATTACHMENT, "вложение");
        add(QL.FILENAME, "вложение");
        add(QL.DATE_BEGIN, "с-даты");
        add(QL.AFTER, "после");
        add(QL.NEWER, "новее");
        add(QL.DATE_END, "заканчивая-датой");
        add(QL.BEFORE, "до-даты");
        add(QL.OLDER, "старее");
        add(QL.OLDER_THAN, "старее-чем");
        add(QL.NEWER_THAN, "новее-чем");
        add(QL.HAS_ATTACHMENTS, "с-вложениями");
        add(QL.UNREAD, "непрочитанные");
        add(QL.SHARED, "общие");
        add(QL.MONTH, "месяц");
        add(QL.YEAR, "год");
    }

    @Override
    public Map<String, String> systemLabels() {
        return RU_SYSTEM_LABELS;
    }

    @Override
    public Map<String, String> systemFolders() {
        return RU_SYSTEM_FOLDERS;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String unreadLabel() {
        return "Непрочитанные";
    }

    @Override
    public String importantLabel() {
        return "Важные";
    }

    @Override
    public List<String> months() {
        return MONTHS;
    }

    @Override
    public List<String> longMonths() {
        return LONG_MONTHS;
    }
}
