package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface SuggestLanguagePack {
    String DRAFT = "Drafts";
    String OUTBOX = "Outbox";
    String INBOX = "Inbox";
    String SPAM = "Spam";
    String TRASH = "Trash";
    String SENT = "Sent";

    enum QL {
        FROM("from"),
        TO("to"),
        LABEL("label"),
        FOLDER("folder"),
        FILTER("filter"),
        BCC("bcc"),
        TYPE("type"),
        SUBJECT("subject"),
        TEXT("text"),
        CC("cc"),
        ATTACHMENT("attachment"),
        FILENAME("filename"),
        DATE_BEGIN("date-begin"),
        AFTER("after"),
        NEWER("newer"),
        DATE_END("date-end"),
        BEFORE("before"),
        OLDER("older"),
        OLDER_THAN("older-than"),
        NEWER_THAN("newer-than"),
        HAS_ATTACHMENTS("has-attachments"),
        UNREAD("unread"),
        SHARED("shared"),
        MONTH("month"),
        YEAR("year");

        private final String value;

        QL(final String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }

        @Override
        public String toString() {
            return value;
        }
    }

    String unreadLabel();

    String importantLabel();

    Map<String, String> systemLabels();

    Map<String, String> systemFolders();

    String ql(String key);

    String ql(QL key);

    QL key(String token);

    String id();

    String label();

    String folder();

    String filter();

    Collection<String> values();

    List<String> months();

    List<String> longMonths();
}
