package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SuggestMultiLanguagePack implements SuggestLanguagePack {
    public static final Map<String, SuggestLanguagePack> LANGUAGES;

    static {
        Map<String, SuggestLanguagePack> map = new HashMap<>();
        map.put(
            ArmenianSuggestLanguagePack.INSTANCE.id(),
            ArmenianSuggestLanguagePack.INSTANCE);
        map.put(
            AzerbaijaniSuggestLanguagePack.INSTANCE.id(),
            AzerbaijaniSuggestLanguagePack.INSTANCE);
        map.put(
            BelarusianSuggestLanguagePack.INSTANCE.id(),
            BelarusianSuggestLanguagePack.INSTANCE);
        map.put(
            EnSuggestLanguagePack.INSTANCE.id(),
            EnSuggestLanguagePack.INSTANCE);
        map.put(
            GeorgianSuggestLanguagePack.INSTANCE.id(),
            GeorgianSuggestLanguagePack.INSTANCE);
        map.put(
            KazakhSuggestLanguagePack.INSTANCE.id(),
            KazakhSuggestLanguagePack.INSTANCE);
        map.put(
            RomanSuggestLanguagePack.INSTANCE.id(),
            RomanSuggestLanguagePack.INSTANCE);
        map.put(
            RuSuggestLanguagePack.INSTANCE.id(),
            RuSuggestLanguagePack.INSTANCE);
        map.put(
            TatarSuggestLanguagePack.INSTANCE.id(),
            TatarSuggestLanguagePack.INSTANCE);
        map.put(
            TurkishSuggestLanguagePack.INSTANCE.id(),
            TurkishSuggestLanguagePack.INSTANCE);
        map.put(
            UkrainianSuggestLanguagePack.INSTANCE.id(),
            UkrainianSuggestLanguagePack.INSTANCE);

        LANGUAGES = Collections.unmodifiableMap(map);
    }

    public static final SuggestLanguagePack INSTANCE
        = new SuggestMultiLanguagePack(
            RuSuggestLanguagePack.INSTANCE,
            EnSuggestLanguagePack.INSTANCE);

    private final List<SuggestLanguagePack> languages;
    private final Set<String> values;
    private final SuggestLanguagePack defaultLanguage;

    public SuggestMultiLanguagePack(
        final SuggestLanguagePack defaultLanguage,
        final SuggestLanguagePack... other)
    {
        this(defaultLanguage, Arrays.asList(other));
    }

    public SuggestMultiLanguagePack(
        final SuggestLanguagePack defaultLanguage,
        final List<SuggestLanguagePack> other)
    {
        this.languages = new ArrayList<>();
        this.languages.add(defaultLanguage);
        this.languages.addAll(other);

        this.values = new HashSet<>();
        this.languages.forEach(l -> values.addAll(l.values()));

        this.defaultLanguage = defaultLanguage;
    }

    @Override
    public Map<String, String> systemLabels() {
        return defaultLanguage.systemLabels();
    }

    @Override
    public Map<String, String> systemFolders() {
        return defaultLanguage.systemFolders();
    }

    @Override
    public String ql(final String key) {
        return defaultLanguage.ql(key);
    }

    @Override
    public String ql(final QL key) {
        return defaultLanguage.ql(key);
    }

    @Override
    public QL key(final String token) {
        for (SuggestLanguagePack lang: languages) {
            QL key = lang.key(token);
            if (key != null) {
                return key;
            }
        }

        return null;
    }

    @Override
    public String id() {
        return defaultLanguage.id();
    }

    @Override
    public String label() {
        return defaultLanguage.label();
    }

    @Override
    public String folder() {
        return defaultLanguage.folder();
    }

    @Override
    public String filter() {
        return defaultLanguage.filter();
    }

    @Override
    public String unreadLabel() {
        return defaultLanguage.unreadLabel();
    }

    @Override
    public String importantLabel() {
        return defaultLanguage.importantLabel();
    }

    @Override
    public Collection<String> values() {
        return values;
    }

    @Override
    public List<String> months() {
        return defaultLanguage.months();
    }

    @Override
    public List<String> longMonths() {
        return defaultLanguage.longMonths();
    }
}
