package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TurkishSuggestLanguagePack extends BaseSuggestLanguagePack {
    public static final TurkishSuggestLanguagePack INSTANCE
        = new TurkishSuggestLanguagePack();

    private static final String ID = "tr";

    private static final Map<String, String> SYSTEM_FOLDERS;
    private static final Map<String, String> SYSTEM_LABELS;

    static {
        Map<String, String> map = new HashMap<>();
        //map.put("Flagged", "FAKE_SEEN_LBL");
        map.put("Read", "FAKE_SEEN_LBL");

        SYSTEM_LABELS = Collections.unmodifiableMap(map);

        Map<String, String> foldersMap = new HashMap<>();

        foldersMap.put(INBOX, "Gelen kutusu");
        foldersMap.put(SENT, "Gönderilmiş Postalar");
        foldersMap.put(DRAFT, "Taslaklar");
        foldersMap.put(SPAM, "Spam");
        foldersMap.put(OUTBOX, "Giden Kutusu");
        foldersMap.put(TRASH, "Çöp Kutusu");

        SYSTEM_FOLDERS = Collections.unmodifiableMap(foldersMap);
    }

    public TurkishSuggestLanguagePack() {
        super();

        for (QL ql: QL.values()) {
            add(ql, ql.value());
        }
    }

    @Override
    public Map<String, String> systemLabels() {
        return SYSTEM_LABELS;
    }

    @Override
    public Map<String, String> systemFolders() {
        return SYSTEM_FOLDERS;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String unreadLabel() {
        return "Okunmadı";
    }

    @Override
    public String importantLabel() {
        return "Önemli";
    }
}