package ru.yandex.msearch.proxy.api.async.suggest.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UkrainianSuggestLanguagePack extends BaseSuggestLanguagePack {
    public static final UkrainianSuggestLanguagePack INSTANCE
        = new UkrainianSuggestLanguagePack();

    private static final String ID = "uk";

    private static final Map<String, String> SYSTEM_FOLDERS;
    private static final Map<String, String> SYSTEM_LABELS;

    static {
        Map<String, String> map = new HashMap<>();
        //map.put("Flagged", "FAKE_SEEN_LBL");
        map.put("Read", "FAKE_SEEN_LBL");

        SYSTEM_LABELS = Collections.unmodifiableMap(map);

        Map<String, String> foldersMap = new HashMap<>();

        foldersMap.put(INBOX, "Вхідні");
        foldersMap.put(SENT, "Надіслані");
        foldersMap.put(DRAFT, "Чернетки");
        foldersMap.put(SPAM, "Спам");
        foldersMap.put(OUTBOX, "Вихідні");
        foldersMap.put(TRASH, "Видалені");

        SYSTEM_FOLDERS = Collections.unmodifiableMap(foldersMap);
    }

    public UkrainianSuggestLanguagePack() {
        super();

        for (QL ql: QL.values()) {
            add(ql, ql.value());
        }
    }

    @Override
    public Map<String, String> systemLabels() {
        return SYSTEM_LABELS;
    }

    @Override
    public Map<String, String> systemFolders() {
        return SYSTEM_FOLDERS;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String unreadLabel() {
        return "Непрочитані";
    }

    @Override
    public String importantLabel() {
        return "Важливі";
    }
}
