package ru.yandex.msearch.proxy.api.async.suggest.mail;

import java.io.IOException;
import java.util.List;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;

/** mail suggest with attach **/
public class AttachMailSuggest extends MailSuggest {
    private final String hid;
    private final String attachname;
    private final String attachExt;
    private final String attType;
    private final String attSubType;

    public AttachMailSuggest(
        final String hid,
        final String attachname,
        final String attachExt,
        final String attType,
        final String attSubType,
        final String mid,
        final String fid,
        final String from,
        final String receivedDate,
        final String subject,
        final List<MailSuggestScope> scopes)
    {
        super(mid, fid, from, receivedDate, subject, scopes, true);

        this.hid = hid;
        this.attachname = attachname;
        this.attachExt = attachExt;
        this.attType = attType;
        this.attSubType = attSubType;
    }

    public AttachMailSuggest(final AttachMailSuggest s, final String prefix) {
        super(s, prefix);

        this.hid = s.hid;
        this.attachname = s.attachname;
        this.attachExt = s.attachExt;
        this.attType = s.attType;
        this.attSubType = s.attSubType;
    }

    @Override
    public Suggest withPrefix(final String prefix) {
        return new AttachMailSuggest(this, prefix);
    }

    @Override
    public void appendToWriter(final JsonWriterBase writer)
        throws IOException
    {
        super.appendToWriter(writer);

        writer.key("hid");
        writer.value(hid);
        writer.key("disposition_filename");
        writer.value(attachname);
        writer.key("disposition_value");
        writer.value("attachment");
        writer.key("fileext");
        writer.value(attachExt);
        writer.key("filename");
        writer.value(attachname);
        writer.key("subtype");
        writer.value(attSubType);
        writer.key("type");
        writer.value(attType);
    }
}
