package ru.yandex.msearch.proxy.api.async.suggest.mail;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser.Email;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

public class MailSuggest extends BasicSuggest {
    private final String mid;
    private final String fid;
    private final String email;
    private final String receivedDate;
    private final String displayName;
    private final Collection<MailSuggestScope> scopes;
    private final Collection<SuggestAttach> attaches;
    private final boolean hasAttachments;

    public MailSuggest(
        final String mid,
        final String fid,
        final String from,
        final String receivedDate,
        final String subject,
        final Collection<MailSuggestScope> scopes,
        final boolean hasAttachments)
    {
        this(
            mid,
            fid,
            from,
            receivedDate,
            subject,
            scopes,
            Collections.emptySet(),
            hasAttachments);
    }

    public MailSuggest(
        final String mid,
        final String fid,
        final String from,
        final String receivedDate,
        final String subject,
        final Collection<MailSuggestScope> scopes,
        final Collection<SuggestAttach> attaches,
        final boolean hasAttachments)
    {
        super(Target.MAIL, subject, "mid:" + mid);

        this.attaches = attaches;
        this.mid = mid;
        this.fid = fid;
        this.scopes = scopes;
        Email email = ContactParser.parseEmail(from);
        this.email = email.address();
        if ("".equals(email.name())) {
            this.displayName = email.address();
        } else {
            this.displayName = email.name();
        }

        this.receivedDate = receivedDate;
        this.hasAttachments = hasAttachments;
    }

    protected MailSuggest(final MailSuggest suggest, final String prefix) {
        super(
            suggest.target(),
            suggest.showText(),
            prefix + suggest.mid);

        this.mid = suggest.mid;
        this.scopes = suggest.scopes;
        this.fid = suggest.fid;
        this.displayName = suggest.displayName;
        this.email = suggest.email;
        this.receivedDate = suggest.receivedDate;
        this.hasAttachments = suggest.hasAttachments;
        this.attaches = suggest.attaches;
    }

    @Override
    public Suggest withPrefix(final String prefix) {
        return new MailSuggest(this, prefix);
    }

    @Override
    public void appendToWriter(final JsonWriterBase writer)
        throws IOException
    {
        super.appendToWriter(writer);

        writer.key("display_name");
        writer.value(displayName);
        writer.key("email");
        writer.value(email);
        writer.key("received_date");
        writer.value(receivedDate);
        writer.key("mid");
        writer.value(mid);
        writer.key("fid");
        writer.value(fid);
        writer.key("scopes");
        writer.startArray();
        for (MailSuggestScope scope: scopes) {
            writer.value(scope.name().toLowerCase(Locale.ENGLISH));
        }
        writer.endArray();

        if (!attaches.isEmpty()) {
            writer.key("attachments");
            writer.value(attaches);
        }

        writer.key("has_attachments");
        writer.value(hasAttachments);
    }
}
