package ru.yandex.msearch.proxy.api.async.suggest.mail;

import java.io.IOException;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class SuggestAttach implements JsonValue {
    private final String hid;
    private final String attachname;
    private final String attachExt;
    private final String attType;
    private final String attSubType;

    public SuggestAttach(
        final String hid,
        final String attachname,
        final String attachExt,
        final String attType,
        final String attSubType)
    {
        this.hid = hid;
        this.attachname = attachname;
        this.attachExt = attachExt;
        this.attType = attType;
        this.attSubType = attSubType;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("hid");
        writer.value(hid);
        writer.key("disposition_filename");
        writer.value(attachname);
        writer.key("disposition_value");
        writer.value("attachment");
        writer.key("fileext");
        writer.value(attachExt);
        writer.key("filename");
        writer.value(attachname);
        writer.key("subtype");
        writer.value(attSubType);
        writer.key("type");
        writer.value(attType);
        writer.endObject();
    }

    @Override
    public String toString() {
        return "SuggestAttach{" +
            "hid='" + hid + '\'' +
            ", attachname='" + attachname + '\'' +
            ", attachExt='" + attachExt + '\'' +
            ", attType='" + attType + '\'' +
            ", attSubType='" + attSubType + '\'' +
            '}';
    }
}
