package ru.yandex.msearch.proxy.api.async.suggest.mtype;

import java.util.Locale;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggests;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;

import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

import ru.yandex.parser.uri.CgiParams;
import ru.yandex.util.string.StringUtils;

public class CategorySuggestRule
    implements SuggestRule<Suggests<? extends Suggest>>
{
    private final Set<String> categories;

    public CategorySuggestRule(final AsyncHttpServer server) {
        this.categories = server.config().filtersConfig().filters().keySet();
    }

    @Override
    public void execute(
        final SuggestRequest<Suggests<? extends Suggest>> request)
        throws HttpException
    {
        CgiParams params = request.cgiParams();
        if (params.getString("request", "").trim().isEmpty()
            && !params.containsKey("ql"))
        {
            request.callback().completed(
                new BasicSuggests(
                    Target.CATEGORY,
                    request.requestParams().length()));
            return;
        }

        BasicSuggests suggests =
            new BasicSuggests(
                Target.CATEGORY,
                request.requestParams().length());

        String requestStr =
            params.getString("request", "").trim().toLowerCase(Locale.ROOT);

        String requestPrefix = params.getString("requestPrefix", "");
        final String searchTextPrefix;
        if (!params.getBoolean("pure", false)) {
            searchTextPrefix = StringUtils.concat(
                requestPrefix,
                request.requestParams().language().filter(),
                ":");
        } else {
            searchTextPrefix = requestPrefix;
        }

        for (String category: categories) {
            if (category.startsWith(requestStr)) {
                suggests.add(
                    new BasicSuggest(
                        Target.CATEGORY,
                        category,
                        searchTextPrefix + category));
            }
        }

        request.callback().completed(suggests);
    }
}
